#pragma once

#include "role_tree.h"

#include <pqxx/transaction_base>

#include <map>

namespace maps::fw_updater::storage::idm {

RoleTree getRoleTree(pqxx::transaction_base& txn);

void addUserRole(pqxx::transaction_base& txn,
                 const Login& login,
                 const SlugPath& slugPath);

void removeUserRole(pqxx::transaction_base& txn,
                    const Login& login,
                    const SlugPath& slugPath);

SlugPaths getUserRoles(pqxx::transaction_base& txn, const Login& login);

std::map<Login, SlugPaths> getAllRoles(pqxx::transaction_base& txn);

bool userHasRoleInProject(pqxx::transaction_base& txn,
                          const Login& login,
                          const std::string& roleKey,
                          Id projectId);

} //namespace maps::fw_updater::storage
