#pragma once

#include <iostream>

namespace maps::fw_updater::storage {

class StdInputStreamAdaptor : public IInputStream
{
public:
    StdInputStreamAdaptor(std::istream& stream)
       : stream_(stream)
    {}

    size_t DoRead(void* buf, size_t len) override
    {
        stream_.read(static_cast<char*>(buf), len);
        return stream_.gcount();
    }

private:
    std::istream& stream_;
};

} // namespace maps::fw_updater::storage

