#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/device_branch.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/firmware.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/firmware_upload.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/firmware_upload_part.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/rollout.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/rollout_history.h>
#include <maps/infra/yacare/include/response.h>

#include <vector>
#include <unordered_map>

namespace maps::fw_updater::storage {

void makeFirmwareUploadPartResponse(
    yacare::Response& response,
    const db::FirmwareUploadPart& firmwareUploadPart);

void makeFirmwareUploadResponse(
    yacare::Response& response,
    const db::FirmwareUpload& firmwareUpload,
    const db::FirmwareUploadParts& firmwareUploadParts);

void makeFirmwareUploadsListResponse(
    yacare::Response& response,
    const std::vector<FirmwareUploadWithParts>& firmwareUploadsWithParts);

void makeFirmwareResponse(
    yacare::Response& response,
    const db::Firmware& firmware);

void makeFirmwaresListResponse(
    yacare::Response& response,
    const db::Firmwares& firmwares);

void makeDeviceBranchResponse(
    yacare::Response& response,
    const db::DeviceBranch& deviceBranch);

void makeDeviceBranchesListResponse(
    yacare::Response& response,
    const db::DeviceBranches& deviceBranches);

void makeRolloutResponse(
    yacare::Response& response,
    const db::RolloutHistory& rolloutHistory,
    const db::Rollout& rollout,
    const db::Firmware& firmware
);

void makeRolloutsListResponse(
    yacare::Response& response,
    const db::RolloutHistories& rolloutHistories,
    const std::unordered_map<db::TId, db::Rollout>& idToRollout,
    const std::unordered_map<db::TId, db::Firmware>& idToFirmware);

} //namespace maps::fw_updater::storage
