#pragma once

#include "retry_strategy.h"
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/config/include/config.h>

#include <contrib/libs/aws-sdk-cpp/aws-cpp-sdk-s3/include/aws/s3/S3Client.h>
#include <contrib/libs/aws-sdk-cpp/aws-cpp-sdk-s3/include/aws/s3/model/CompletedPart.h>

#include <string>
#include <vector>

namespace maps::fw_updater::storage::s3 {

using UploadId = std::string;

class ObjectHolder {
public:
    explicit ObjectHolder(Aws::S3::Model::GetObjectResult&& result)
        : result_(std::move(result))
    {}

    std::istream& getBody()
    {
        return result_.GetBody();
    }

private:
    Aws::S3::Model::GetObjectResult result_;
};

class S3Client {
public:
    explicit S3Client(const config::S3Config& s3Config,
                      RetryStrategyPtr retryStrategy = defaultRetryStrategy());

    UploadId createMultipartUpload(const std::string& key);

    Aws::S3::Model::CompletedPart uploadPart(
        const std::string& key,
        const UploadId& uploadId,
        int partId,
        std::streambuf& content);

    void completeMultipartUpload(
        const std::string& key,
        const UploadId& uploadId,
        std::vector<Aws::S3::Model::CompletedPart> completedParts);

    void abortMultipartUpload(const std::string& key, const UploadId& uploadId);

    ObjectHolder getObject(const std::string& key);

    void deleteObject(const std::string& key);

    // Used in unit tests
    void createBucket();

    std::string makeReadingUrl(const std::string& key) const;

private:
    const std::string publicReadHost_;
    const std::string bucket_;
    std::shared_ptr<Aws::S3::S3Client> client_;
};

} // maps::fw_updater::storage::s3
