#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/storage/lib/idm/idm_service.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/idm/user_role_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/firmware.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/rollout.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/rollout_history.h>
#include <maps/libs/auth/include/user_info.h>
#include <yandex/maps/proto/firmware_updater/storage/firmware.pb.h>
#include <yandex/maps/proto/firmware_updater/storage/rollout.pb.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace proto = yandex::maps::proto::firmware_updater::storage;

namespace maps::fw_updater::storage::tests {

const std::string PROTOBUF_MEDIA_TYPE = "application/x-protobuf";

inline auth::UserInfo makeUserInfo(const std::string& login)
{
    auth::UserInfo userInfo{};
    userInfo.setLogin(login);
    return userInfo;
}

inline bool areEqual(const proto::Firmware& pb, const db::Firmware& db)
{
    return pb.hardware() == db.hardwareId()
        && pb.slot() == toString(db.slot())
        && pb.version() == db.version()
        && pb.version_seq() == db.versionSeq()
        && pb.download_url() == db.url()
        && pb.content_size() == db.size()
        && pb.content_md5() == db.md5();
}

inline bool areEqual(
    const proto::Rollout& pb,
    const db::RolloutHistory& dbRolloutHistory,
    const db::Rollout& dbRollout,
    const db::Firmware& dbFirmware)
{
    return std::stol(pb.id()) == dbRollout.id()
        && areEqual(pb.firmware(), dbFirmware)
        && pb.branch() == dbRollout.branch()
        && pb.status() == toString(dbRolloutHistory.status())
        && pb.percent() == dbRolloutHistory.percent()
        && pb.created_by() == dbRolloutHistory.createdBy()
        && pb.created_at() == std::chrono::duration_cast<std::chrono::milliseconds>(
            dbRolloutHistory.createdAt().time_since_epoch()).count();
}

} // namespace maps::fw_updater::storage::tests
