#include "configuration.h"

namespace maps::fw_updater {

Configuration::Configuration(config::Config cfg)
    : cfg_(std::move(cfg))
    , poolHolder_(cfg_.makePoolHolder())
    , signatureKey_(cfg_.updater().signatureKey())
{
}

ConfigurationHolder& Configuration::instance()
{
    auto& instance = instanceImpl();
    REQUIRE(instance, "Configuration instance is not initialized");
    return instance;
}

ConfigurationHolder Configuration::swap(ConfigurationHolder configuration)
{
    std::swap(instanceImpl(), configuration);
    return configuration;
}

} //namespace maps::fw_updater
