#include <maps/infra/yacare/include/yacare.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/config/include/config.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <memory>

namespace maps::fw_updater {

class Configuration;
using ConfigurationHolder = std::unique_ptr<Configuration>;

class Configuration
{
public:
    Configuration(config::Config cfg);

    static ConfigurationHolder& instance();

    static ConfigurationHolder swap(ConfigurationHolder configuration);

    const config::Config& config() const { return cfg_; }

    pgpool3::Pool& pool() { return poolHolder_.pool(); }

    const std::string& signatureKey() { return signatureKey_; }

private:
    static ConfigurationHolder& instanceImpl()
    {
        static ConfigurationHolder instance_;
        return instance_;
    }

    config::Config cfg_;
    wiki::common::PoolHolder poolHolder_;
    const std::string& signatureKey_;
};

inline ConfigurationHolder makeConfiguration(config::Config cfg)
{
    return std::make_unique<Configuration>(std::move(cfg));
}

inline ConfigurationHolder& configuration()
{
    return Configuration::instance();
}

} //namespace maps::fw_updater
