#pragma once

#include <string>
#include <vector>
#include <array>

namespace maps::fw_updater::fw_signature {

constexpr size_t HMAC_SHA1_SIZE = 20;
using HmacSha1Digest = std::array<unsigned char, HMAC_SHA1_SIZE>;

HmacSha1Digest hmacSha1(const std::string& signatureKey,
                        const std::vector<std::string>& messageChunks);

bool verifyFirmwareSignatureImpl(const std::string& firmwareSignature,
                                 const std::string& userAgent,
                                 const std::string& host,
                                 const std::string& requestMethod,
                                 const std::string& pathAndQuery,
                                 const std::string& requestBody,
                                 const std::string& signatureKey);

}; // maps::fw_updater::fw_signature