#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/enums.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/infra/yacare/include/yacare.h>

#include <string>

namespace {

template <typename T>
T parseEnumParam(const std::string& param)
{
    auto result = maps::enum_io::tryFromString<T>(param);
    if (!result) {
        throw std::bad_cast();
    }
    return *result;
}

} // namespace

using maps::fw_updater::db::Slot;

template <>
struct yacare::Parser<Slot>
{
    Slot operator()(const std::string& param) const
    {
        return parseEnumParam<Slot>(param);
    }
};

YCR_QUERY_PARAM(hardware, std::string);

YCR_QUERY_PARAM(slot, Slot);
YCR_QUERY_PARAM(slots, std::vector<Slot>, YCR_CONSTRAINT(yacare::constraints::nonempty()));

YCR_QUERY_PARAM(deviceid, std::string);
