#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/unittest/include/database_fixture.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/unittest/include/unittest_config.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/unittest/env.h>

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/updater/lib/configuration.h>
#include <maps/libs/common/include/file_utils.h>
#include <maps/libs/http/include/http.h>

#include <string>

namespace maps::fw_updater::tests {

const std::string SIGNATURE_KEY = "0251075282e1c694f4b86c39e7d144dd";

class PatchFirmwareSignatureFixture
{
public:
    explicit PatchFirmwareSignatureFixture(xml3::Doc& configDoc)
    {
        auto node = configDoc.node("/config/updater");
        node.setAttr("signature-key", SIGNATURE_KEY);
    }
};

inline unittest::WithUnittestConfig<unittest::DatabaseFixture, PatchFirmwareSignatureFixture>& playground()
{
    static unittest::WithUnittestConfig<unittest::DatabaseFixture, PatchFirmwareSignatureFixture> global{};
    return global;
}

class Fixture: public testing::Test
{
public:
    Fixture()
    {
        clearData();
        Configuration::swap(makeConfiguration(playground().config()));

        populateDb("data.sql");
    }

    pgpool3::Pool& pgPool() { return playground().pool(); }

    maps::pgpool3::TransactionHandle txnHandle()
    {
        return pgPool().masterWriteableTransaction();
    }

    void populateDb(const std::string& filename)
    {
        clearData();
        insertData(filename);
    }

private:
    void clearData()
    {
        playground().postgres().truncateTables();
    }

    void insertData(const std::string& filename)
    {
        auto txn = txnHandle();
        txn->exec(maps::common::readFileToString(SRC_(filename)));
        txn->commit();
    }
};

} // namespace maps::fw_updater::tests
