#!/usr/bin/perl
############################################################################
# checksignal.pl
#
# Runs a series of diagnostic tests on the modem to determine what the
#
# - Signal strength is
# - Network registration state
# - SIM state (Pin Lock / Blocked / other error )
# - Service level available and used (GPRS/3G/etc..)
# - Modem Type / IMEI / Firmware version
#
# Author:       Andrew O'Connell
############################################################################


use strict;
use warnings;

use Device::Modem;
use Getopt::Std;

$| = 1;

my (%opts, @recipients);
my ($modem, $msg);

my $device = '/dev/modemAT';
my $pin    = '';

main();

sub main {
    init();
    set_opts();
    send_cmds();
    disconnect();
}



sub init {
    $modem = Device::Modem->new(port => $device);

    if ($modem->connect(baudrate => 115200)) {
    } else {
        print "Sorry, no connection with modem possible, tests aborted\n";
    }
}

sub set_opts {
    $modem->is_active();
    $modem->echo(0);
    $modem->verbose(1);
}

sub send_cmds {
    my $answer="";
    $modem->atsend("AT\r");
    $answer = $modem->answer()."\n";


    #Bands
    $modem->atsend("AT+CNBP=0x0002000004400180,0x0000000000080004,0x000000000000003F\r");
    $answer = $modem->answer();
    #$modem->atsend("AT+CNVW=6792,0,\"00000200\"\r");
    #$answer = $modem->answer();


    #GPS
    $modem->atsend("AT+CGPSAUTO=1\r");
    $answer = $modem->answer();
    $modem->atsend("AT+CGSOCKCONT=1,\"IP\",\"internet\"\r");
    $answer = $modem->answer();
    $modem->atsend("AT+CGPSURL=\"supl.google.com:7276\"\r");
    $answer = $modem->answer();
    $modem->atsend("AT+CGPSSSL=0\r");
    $answer = $modem->answer();

    #APN
    $modem->atsend("AT+CGDCONT=1,\"IP\",\"internet\"\r");
    $answer = $modem->answer();
}

sub disconnect {
    $modem->disconnect();
}

