SUMMARY = "nanopi-neo4 simcom modem recipe"
DESCRIPTION = "Recipe for adding files for nanopi neo4 LTE modem operation"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"

RDEPENDS_${PN} += "perl bash"

SRC_URI += " \
    file://etc \
    file://lib \
    file://opt \
    file://modem.service \
"

REQUIRED_DISTRO_FEATURES += "systemd"

inherit systemd

do_install() {
    install -d ${D}/etc
    install -d ${D}/lib
    install -d ${D}/opt

    cp -R --no-dereference --preserve=mode,links -v ${WORKDIR}/etc ${D}/
    cp -R --no-dereference --preserve=mode,links -v ${WORKDIR}/lib ${D}/
    cp -R --no-dereference --preserve=mode,links -v ${WORKDIR}/opt ${D}/

    install -d ${D}/etc/modules-load.d/
    install -d ${D}${systemd_system_unitdir}

    install -m 0644 ${WORKDIR}/modem.service ${D}${systemd_system_unitdir}

    ln -sf ../modules ${D}/etc/modules-load.d/modules.conf
}

FILES_${PN} += " \
    /etc/* \
    /lib/udev/rules.d \
    /opt/* \
"

SYSTEMD_SERVICE_${PN} += "modem.service"
