SUMMARY = "Build mrc-drive-app from arcadia"
SECTION = "mrc" 
LICENSE = "CLOSED" 

RDEPENDS_${PN} += "bash"

SRC_URI += "\
    file://mrc-drive-launcher.sh \
    file://mrc-drive.service \
"

MRC_APP_DIR="/maps/mobile/apps/mrc_drive_app/bin"

S="${WORKDIR}"

do_compile() {
    ${ARCADIA}/ya make -r --maps-mobile --target-platform=clang8-linux-aarch64 -DNO_GRAPHICS -DNO_DEBUGINFO ${ARCADIA}${MRC_APP_DIR} -o ${WORKDIR}
}

REQUIRED_DISTRO_FEATURES += "systemd"
inherit systemd

do_install() {
    install -d ${D}${bindir}
    install -m 0755 ${WORKDIR}${MRC_APP_DIR}/mrc-drive-app ${D}${bindir}

    install -d ${D}${systemd_system_unitdir}
    install -m 0644 ${WORKDIR}/mrc-drive.service ${D}${systemd_system_unitdir}/

    install -d ${D}/usr/local/bin/
    install -m 0755 ${WORKDIR}/mrc-drive-launcher.sh ${D}/usr/local/bin/
}

FILES_${PN} += " \
    ${bindir}/ \
    /usr/local/bin/ \
"

SYSTEMD_SERVICE_${PN} += "mrc-drive.service"
