#!/bin/bash

trap 'kill 0' INT TERM EXIT

ENVIRONMENT_FILE=/etc/yandex/environment.type
env_type=`cat $ENVIRONMENT_FILE`

app_id=com.yandex.maps.mrcdrive
if [ $env_type = "testing" ]
then
    app_id+=".testing"
fi

echo "[mrc-drive-launcher] Run mrc-drive with environment $env_type, app_id $app_id"

YANDEX_MAPS_RUNTIME_APP_ID=$app_id \
YANDEX_MAPS_RUNTIME_DEVICE_MODEL=nanopi-neo4 \
YANDEX_MAPS_RUNTIME_HOSTS_ENV=$env_type \
YANDEX_MAPS_HOME=/data/mrc_data \
/usr/bin/mrc-drive-app --log-level=debug

echo "[mrc-drive-launcher] mrc-drive app exited with code $?"
