SUMMARY = "MRC drive application"
DESCRIPTION = "Recipe for bringing mrc drive application and libraries into the image"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"

RDEPENDS_mrc-drive-app += "bash"

SANDBOX_URL = "https://proxy.sandbox.yandex-team.ru"
OPENCV_LIBS_RESOURCE_ID = "1482598479"
MOBILE_LIBS_RESOURCE_ID = "1482585252"
MRC_DRIVE_APP_RESOURCE_ID = "1343842547"

SRC_URI += " \
    file://mrc-drive.service \
    file://mrc-drive-launcher.sh \
"

do_install() {
    install -d ${D}${systemd_system_unitdir}
    install -m 0644 ${WORKDIR}/mrc-drive.service ${D}${systemd_system_unitdir}/

    install -d ${D}/usr/local/bin/
    install -m 0755 ${WORKDIR}/mrc-drive-launcher.sh ${D}/usr/local/bin/

    install -d ${D}${libdir}
    install -d ${D}${bindir}

    # download and install opencv libraries
    wget ${SANDBOX_URL}/${OPENCV_LIBS_RESOURCE_ID} -O ${WORKDIR}/opencv-libs.tar.gz
    tar xfz ${WORKDIR}/opencv-libs.tar.gz -C ${D}${libdir}

    # download and install mobile libraries: runtime, mapkit, mrc
    wget ${SANDBOX_URL}/${MOBILE_LIBS_RESOURCE_ID} -O ${WORKDIR}/mobile-libs.tar.gz
    tar xfz ${WORKDIR}/mobile-libs.tar.gz -C ${D}${libdir}

    # download and install mrc app binary
    wget ${SANDBOX_URL}/${MRC_DRIVE_APP_RESOURCE_ID} -O ${D}${bindir}/mrc-drive-app
    chmod +x ${D}${bindir}/mrc-drive-app
}

FILES_${PN} += " \
    ${systemd_system_unitdir}/ \
    ${bindir}/ \
    ${libdir}/ \ 
    /usr/local/bin/ \
"

