SUMMARY = "MRC update scripts"
DESCRIPTION = "Recipe for bringing mrc updater scripts into the image"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"

SRC_URI += " \
    file://mrc-drive-update.service \
"

REQUIRED_DISTRO_FEATURES += "systemd"

inherit systemd

do_install() {
    # install firmware signature key
    echo ${SIGNATURE_KEY} >> ${WORKDIR}/firmware_signature.key
    install -d ${D}/etc/yandex
    install -m -400 ${WORKDIR}/firmware_signature.key ${D}/etc/yandex/firmware_signature.key
    
    install -d ${D}${systemd_system_unitdir}
    install -m 0644 ${WORKDIR}/mrc-drive-update.service ${D}${systemd_system_unitdir}/

    install -d ${D}/usr/local/bin/
    install -m 0755 ${ARCADIA}/maps/wikimap/mapspro/services/mrc/drive/firmware_updater/client/lib/*.py ${D}/usr/local/bin/
    install -m 0755 ${ARCADIA}/maps/wikimap/mapspro/services/mrc/drive/firmware_updater/client/nanopi_neo4/*.py ${D}/usr/local/bin/
}

FILES_${PN} += " \
    /usr/local/bin/ \
"

SYSTEMD_SERVICE_${PN} += "mrc-drive-update.service"
