#!/usr/bin/python3
'''
    Commands:
        SOURCE: get power source
        STATUS: get actual status
        UPS-ON: enable UPS
        UPS-OFF: disable UPS
        SHUTDOWN: shutdown system now
'''

import socket
import os
import sys
import json
try:
    sf = sys.argv[1]
    command = sys.argv[2]
except IndexError:
    try:
        sf = '/run/pm.socket'
        command = sys.argv[1]
    except IndexError:
        print("Usage: {0} [socket] command".format(sys.argv[0]))
        sys.exit(0)

#sf = '/run/pm.socket'
if os.path.exists(sf):
    try:
        sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        sock.connect(sf)
        data = ''

        if command == 'source':
            sock.sendall("SOURCE\n".encode('utf-8'))
        elif command == 'status':
            sock.sendall("STATUS\n".encode('utf-8'))
        elif command == 'ups-off':
            sock.sendall("UPS-OFF\n".encode('utf-8'))
        elif command == 'ups-on':
            sock.sendall("UPS-ON\n".encode('utf-8'))
        elif command == 'shutdown':
            sock.sendall("SHUTDOWN\n".encode('utf-8'))
        else:
            print("Unknown command")
            sock.close()
            sys.exit(1)

        data = sock.recv(1024)
        print(json.loads(data.decode('utf-8')))
        sock.close()
        sys.exit(0)

    except socket.error as e:
        print (e)
        sys.exit(1)

    finally:
        sock.close()
