SUMMARY = "nanopi power manager recipe"
SECTION = "examples" 
LICENSE = "CLOSED" 

SRC_URI = "\
    file://power \
    file://power-manager.service \
"

DEPENDS += "wiringpi python3-native"
RDEPENDS_${PN} += "python3-core bash"

BATTERY_MANAGER_DIR="/maps/wikimap/mapspro/services/mrc/drive/mobile/yocto/tools/power_manager"
LDFLAGS="-L${WORKDIR} -lwiringPi -lwiringPiDev"
ARCADIA_BATTERY_MANAGER="${ARCADIA}${BATTERY_MANAGER_DIR}"
S="${WORKDIR}"

inherit systemd

do_compile() {
    cp ${WORKDIR}/recipe-sysroot/usr/lib/libwiringPi.so ${WORKDIR}
    cp ${WORKDIR}/recipe-sysroot/usr/lib/libwiringPiDev.so ${WORKDIR}

    cp ${ARCADIA_BATTERY_MANAGER}/_ya.make ${ARCADIA_BATTERY_MANAGER}/ya.make
    cp ${ARCADIA_BATTERY_MANAGER}/bin/_ya.make ${ARCADIA_BATTERY_MANAGER}/bin/ya.make
    cp ${ARCADIA_BATTERY_MANAGER}/lib/_ya.make ${ARCADIA_BATTERY_MANAGER}/lib/ya.make
    
    ${ARCADIA}/ya make -r -k --target-platform=default-linux-aarch64 \
        -DCFLAGS="-I${WORKDIR}/recipe-sysroot/usr/include" \
        -DLDFLAGS="${LDFLAGS}" ${ARCADIA_BATTERY_MANAGER} -o ${WORKDIR}
    cp ${WORKDIR}${BATTERY_MANAGER_DIR}/bin/battery-manager ${WORKDIR}/power

    # clear all
    rm -f ${ARCADIA_BATTERY_MANAGER}/ya.make ${ARCADIA_BATTERY_MANAGER}/bin/ya.make ${ARCADIA_BATTERY_MANAGER}/lib/ya.make
}

do_install() {
    install -d ${D}/opt
    cp -R --no-dereference --preserve=mode,links -v ${WORKDIR}/power ${D}/opt

    install -d ${D}${systemd_system_unitdir}
    install -m 0644 ${WORKDIR}/power-manager.service ${D}${systemd_system_unitdir}
}

FILES_${PN} += "/opt/power/*"

SYSTEMD_SERVICE_${PN} += "power-manager.service"
REQUIRED_DISTRO_FEATURES += "systemd"

