# DO NOT EDIT THIS FILE
#
# Please edit /boot/armbianEnv.txt to set supported parameters
#

setenv load_addr "0x39000000"
setenv overlay_error "false"
# default values
setenv verbosity "1"
setenv console "both"
setenv rootfstype "ext4"
setenv docker_optimizations "on"
setenv fdtfile "rockchip/rk3399-nanopi4-rev04.dtb"

echo "Boot script loaded from ${devtype} ${devnum}"

if test -e ${devtype} ${devnum} ${prefix}rkEnv.txt; then
	load ${devtype} ${devnum} ${load_addr} ${prefix}rkEnv.txt
	env import -t ${load_addr} ${filesize}
fi

if test "${logo}" = "disabled"; then setenv logo "logo.nologo"; fi

# Tinkerboard walkaround.
if test "${console}" = "ttyFIQ0,1500000"; then setenv console "both"; fi
if test "${console}" = "display" || test "${console}" = "both"; then setenv consoleargs "console=tty1"; fi
if test "${console}" = "serial" || test "${console}" = "both"; then setenv consoleargs "console=ttyFIQ0,1500000 ${consoleargs}"; fi

# get PARTUUID of first partition on SD/eMMC the boot script was loaded from
if test "${devtype}" = "mmc"; then part uuid mmc ${devnum}:1 partuuid; fi





# Init rauc variables
test -n "${BOOT_ORDER}" || setenv BOOT_ORDER "rootfs0 rootfs1"
test -n "${BOOT_rootfs0_LEFT}" || setenv BOOT_rootfs0_LEFT 3
test -n "${BOOT_rootfs1_LEFT}" || setenv BOOT_rootfs1_LEFT 3

# Coose boot device logic
setenv rauc_slot "unknown"
setenv rootdev

for BOOT_SLOT in ${BOOT_ORDER}; do
    if test "x${rootdev}" != "x"; then
        # skip remaining slots
    elif test "x${BOOT_SLOT}" = "xrootfs0"; then
        if test ${BOOT_rootfs0_LEFT} -gt 0; then
            echo "Found valid slot rootfs0, ${BOOT_rootfs0_LEFT} attempts remaining"
            setexpr BOOT_rootfs0_LEFT ${BOOT_rootfs0_LEFT} - 1
            setenv rootdev "/dev/mmcblk1p2"
            setenv rauc_slot "rootfs0"
        fi
    elif test "x${BOOT_SLOT}" = "xrootfs1"; then
        if test ${BOOT_rootfs1_LEFT} -gt 0; then
            echo "Found valid slot rootfs1, ${BOOT_rootfs1_LEFT} attempts remaining"
            setexpr BOOT_rootfs1_LEFT ${BOOT_rootfs1_LEFT} - 1
            setenv rootdev "/dev/mmcblk1p3"
            setenv rauc_slot "rootfs1"
        fi
    fi
done

if test -n "${rootdev}"; then
    saveenv
else
    # Fallback
    setenv BOOT_rootfs0_LEFT 3
    setenv BOOT_rootfs1_LEFT 3
    saveenv
    reset
fi

setenv bootargs "earlyprintk root=${rootdev} rootwait rootfstype=${rootfstype} rauc.slot=${rauc_slot} ${consoleargs} panic=10 consoleblank=0 loglevel=${verbosity} ubootpart=${partuuid} usb-storage.quirks=${usbstoragequirks} ${extraargs} ${extraboardargs}"

if test "${docker_optimizations}" = "on"; then setenv bootargs "${bootargs} cgroup_enable=cpuset cgroup_memory=1 cgroup_enable=memory swapaccount=1"; fi

load ${devtype} ${devnum} ${kernel_addr_r} ${prefix}Image

load ${devtype} ${devnum} ${fdt_addr_r} ${prefix}/${fdtfile}
fdt addr ${fdt_addr_r}
fdt resize 65536
for overlay_file in ${overlays}; do
	if load ${devtype} ${devnum} ${load_addr} ${prefix}overlay/${overlay_prefix}-${overlay_file}.dtbo; then
		echo "Applying kernel provided DT overlay ${overlay_prefix}-${overlay_file}.dtbo"
		fdt apply ${load_addr} || setenv overlay_error "true"
	fi
done
if test "${overlay_error}" = "true"; then
	echo "Error applying DT overlays, restoring original DT"
	load ${devtype} ${devnum} ${fdt_addr_r} ${prefix}/${fdtfile}
else
	if load ${devtype} ${devnum} ${load_addr} ${prefix}overlay/${overlay_prefix}-fixup.scr; then
		echo "Applying kernel provided DT fixup script (${overlay_prefix}-fixup.scr)"
		source ${load_addr}
	fi
	if test -e ${devtype} ${devnum} ${prefix}fixup.scr; then
		load ${devtype} ${devnum} ${load_addr} ${prefix}fixup.scr
		echo "Applying user provided fixup script (fixup.scr)"
		source ${load_addr}
	fi
fi

booti ${kernel_addr_r} - ${fdt_addr_r}

# Recompile with:
# mkimage -C none -A arm -T script -d /boot/boot.cmd /boot/boot.scr
