#include <maps/libs/log8/include/log8.h>

#include <maps/wikimap/mapspro/services/mrc/drive/mobile/yocto/tools/power_manager/lib/power_manager.h>
#include <maps/wikimap/mapspro/services/mrc/drive/mobile/yocto/tools/power_manager/lib/server.h>
#include <maps/wikimap/mapspro/services/mrc/drive/mobile/yocto/tools/power_manager/lib/power_statistics.h>
#include <maps/wikimap/mapspro/services/mrc/drive/mobile/yocto/tools/power_manager/lib/battery.h>
#include <maps/wikimap/mapspro/services/mrc/drive/mobile/yocto/tools/power_manager/lib/ini_parser.h>

#include <memory>
#include <future>
#include <chrono>
#include <iostream>
#include <fstream>
#include <string>

using namespace std::chrono_literals;
using namespace maps::mrc::drive;

int main(int argc, const char* argv[])
{
    if (argc > 2) {
        INFO() << "Usage: " << argv[0] << " [config_file]";
        return EXIT_FAILURE;
    }

    const char* configName = (argc == 2) ? argv[1] : "/opt/power/config.ini";
    std::ifstream input(configName);
    if (!input.is_open()) {
        ERROR() << "Cannot open config file " << configName;
        return EXIT_FAILURE;
    }

    Cfg::IniSettings config = Cfg::load(input);

    try {
        auto settings = config.getSection("charger");

        auto batteryData = std::make_shared<Battery>(
            std::stoi(settings["channel"]),
            std::stoi(settings["address"], nullptr, 16),
            static_cast<BatteryType>(std::stoi(settings["battery"])),
            std::stoi(settings["enable_ups"])
        );

        auto powerStatistics = std::make_shared<PowerStatistics>();

        auto powerManager = std::make_unique<PowerManager>(
            batteryData,
            powerStatistics,
            std::stoi(settings["poll"]),
            std::stoi(settings["empty_loops"]),
            std::stoi(settings["max_time_on_battery"])
        );

        auto server = std::make_unique<Server>(
            batteryData,
            powerStatistics,
            settings["sock"]
        );

        auto serverFuture = std::async(
            std::launch::async,
            [&]() { server->start(); }
        );

        for (;;) {
            auto status = serverFuture.wait_for(0ms);
            if (status == std::future_status::ready) {
                std::cout << "Relaunching server...";
                serverFuture = async(
                    std::launch::async,
                    [&]() { server->start(); }
                );
            }

            powerManager->runTick();
        }
    } catch(const std::exception& e) {
        ERROR() << "Unexpectedly exited: " << e.what();
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
