#pragma once

#include <string>
#include <unordered_map>
#include <iostream>

namespace maps::mrc::drive::Cfg {

using Section = std::unordered_map<std::string, std::string>;

class IniSettings
{
 public:
    Section& addSection(const std::string& name);
    const Section& getSection(const std::string& name) const;

 private:
    std::unordered_map<std::string, Section> sections_;
};

IniSettings load(std::istream& input);

} // namespace maps::mrc::drive::Cfg