#pragma once

#include <string>
#include <chrono>
#include <memory>

namespace maps::mrc::drive {

class Server;
class Battery;
class PowerStatistics;

class PowerManager
{
 public:
    PowerManager(
        std::shared_ptr<Battery> data,
        std::shared_ptr<PowerStatistics> statistics,
        int pollSeconds,
        int empty_loops,
        int maxSecsOnBattery
    );

    void runTick();

 private:
    std::shared_ptr<Battery> batteryData_;
    std::shared_ptr<PowerStatistics> powerStatistics_;

    std::chrono::seconds secsPollInterval_;
    int maxEmptyLoops_;
    std::chrono::seconds maxSecsOnBattery_;

    int emptyLoops_ = 0;
    std::string sourceName_;
    bool isCharged_ = false;
};

} // namespace maps::mrc::drive