#include "power_statistics.h"

#include <chrono>

namespace maps::mrc::drive {

using namespace std::chrono;

seconds PowerStatistics::secondsSinceCharging() const
{
    return duration_cast<seconds>(
        system_clock::now() - chargingStart_
    );
}

seconds PowerStatistics::secondsOnBattery() const
{
    return batterySecs_;
}

seconds PowerStatistics::secondsOnCharger() const
{
    return onChargerSecs_;
}

void PowerStatistics::beginOnBattery()
{
    batteryStart_ = system_clock::now();
}

void PowerStatistics::beginOnCharger()
{
    onChargerStart_ = system_clock::now();
}

void PowerStatistics::beginCharging()
{
    chargingStart_ = system_clock::now();
}

void PowerStatistics::updateTimeOnCharger()
{
    onChargerSecs_ = duration_cast<seconds>(
        system_clock::now() - onChargerStart_
    );
}

void PowerStatistics::updateTimeOnBattery()
{
    batterySecs_ = duration_cast<seconds>(
        system_clock::now() - batteryStart_
    );
}

} // namespace maps::mrc::drive