#pragma once

#include <memory>
#include <chrono>
#include <string>

namespace maps::mrc::drive {

class PowerStatistics
{
    using TimePoint = std::chrono::time_point<std::chrono::system_clock>;

 public:
    std::chrono::seconds secondsOnBattery() const;
    std::chrono::seconds secondsOnCharger() const;
    std::chrono::seconds secondsSinceCharging() const;

    void beginOnBattery();
    void beginOnCharger();
    void beginCharging();

    void updateTimeOnBattery();
    void updateTimeOnCharger();

 private:
    TimePoint onChargerStart_;
    TimePoint batteryStart_;
    TimePoint chargingStart_;

    std::chrono::seconds onChargerSecs_;
    std::chrono::seconds batterySecs_;

};

} // namespace maps::mrc::drive