#pragma once

#include <maps/libs/json/include/builder.h>
#include <string>
#include <memory>

namespace maps::mrc::drive {

class Battery;
class PowerStatistics;

class Server
{
 public:
    Server(
        std::shared_ptr<Battery> data,
        std::shared_ptr<PowerStatistics> statistics,
        std::string sock = "/run/pm.socket");

    void start();

    void generateStatusMsg(maps::json::Builder& builder) const;

 private:
    std::shared_ptr<Battery> batteryData_;
    const std::shared_ptr<PowerStatistics> powerStatistics_;
    std::string socketName_;
};

} // namespace maps::mrc::drive