#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/metadata.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/monitoring/include/check.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/monitoring/include/common.h>

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>

#include <maps/libs/common/include/exception.h>


#include <chrono>
#include <iostream>

using namespace maps::mrc;
using namespace maps::mrc::eye;

int main(int argc, char** argv) try {
    maps::log8::setLevel(maps::log8::Level::FATAL);

    maps::cmdline::Parser parser;

    auto mrcConfigPath = parser.string("mrc-config")
            .help("path to mrc config");

    auto secretVersion = parser.string("secret-version")
            .help("version for secrets from yav.yandex-team.ru");

    auto key = parser.string("metadata")
        .help("service metadata key")
        .required();

    auto warnTime = parser.num("warn")
        .help("warn time in hours")
        .defaultValue(24);

    auto errorTime = parser.num("error")
        .help("error time in hours")
        .defaultValue(48);

    parser.parse(argc, argv);

    const auto config = common::templateConfigFromCmdPath(secretVersion, mrcConfigPath);

    auto pool = config.makePoolHolder();
    auto txn = pool.pool().slaveTransaction();

    auto metadata = MetadataManager(key, *txn);

    const auto message = checkRunTime(
        metadata,
        std::chrono::hours{warnTime},
        std::chrono::hours{errorTime}
    );

    std::cout << message << std::endl;

    return EXIT_SUCCESS;
} catch (const std::exception& e) {
    std::cout << juggler::error(e.what()) << std::endl;
    return EXIT_FAILURE;
} catch (...) {
    std::cout << juggler::error("unknown exception") << std::endl;
    return EXIT_FAILURE;
}
