import sys

from ..lib.train_faster_rcnn.models.faster_rcnn import FasterRCNN
from ..lib.train_faster_rcnn.io_wrappers import wrapper_factory
from ..lib.train_faster_rcnn.data_preprocessors.faster_rcnn_preprocessor import FasterRCNNPreprocessor
from ..lib.train_faster_rcnn.configs.faster_rcnn_conf import get_config


def main():
    run_type = 'nirvana'
    if len(sys.argv) > 1 :
        run_type = sys.argv[1]
    io_wrapper = wrapper_factory.get_io_wrapper(run_type)()
    params = dict(get_config())
    preprocessor = FasterRCNNPreprocessor(params, io_wrapper)
    model = FasterRCNN(preprocessor)
    model.train()


if __name__ == '__main__':
    main()
