#
import tensorflow as tf

from .faster_rcnn import FasterRcnnFPNResnet50
from ..utils.training import (freeze_batch_normalization, freeze_layers_before)


def build_model(params: dict, classes: list) -> tf.keras.Model:
    model = FasterRcnnFPNResnet50(params, classes)
    freeze_batch_normalization(model.backbone)
    freeze_layers_before(model.backbone, 'conv2_block3_out')
    return model
