config = {"batch_size": 8,
          "epochs": 10,
          "lr_boundaries": (7, 8, 9),
          "lr_values": [0.00005 * (0.5**i) for i in range(4)],
          "optimizer": "adam",
          "has_valid": True,
          "rpn": {"anchor_ratios": (0.25, 0.5, 1, 2),
                  "anchor_strides": (4, 8, 16, 32, 64),
                  "anchor_sizes": (32, 64, 128, 256, 512),
                  "localization_loss_weight": 2.0},
          "fast_rcnn": {"classification_loss_weight": 4.0},
          "nms_rpn": {"iou_threshold": 0.7},
          "nms_faster_rcnn": {"max_output_size_per_class": 100,
                              "max_total_size": 200,
                              "iou_threshold": 0.5,
                              "score_threshold": 0.0},
          "faster_rcnn": {"num_proposals_train": 1000,
                          "num_proposals_predict": 200}}


def get_config():
    return config
