import vh3
from typing import Literal, NamedTuple, Sequence, Union


class PulsarAddInstanceOutput(NamedTuple):
    info: vh3.JSON
    link: vh3.HTML


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/c18f3937-db99-46bf-a1bb-e524affb7cc9")
def pulsar_add_instance(
    *,
    pulsar_token: vh3.Secret,
    model_name: vh3.String,
    model_version: vh3.String = None,
    model_options: vh3.String = None,
    dataset_name: vh3.String = None,
    dataset_uid: vh3.String = None,
    dataset_alias: vh3.String = None,
    dataset_version: vh3.Integer = None,
    dataset_info: vh3.String = None,
    tags: vh3.MultipleStrings = (),
    user_datetime: vh3.String = None,
    name: vh3.String = None,
    description: vh3.String = None,
    experiment_id: vh3.String = None,
    links: vh3.String = None,
    per_object_data_metainfo: vh3.String = None,
    diff_tool_config: vh3.String = None,
    save_tfevents: vh3.Boolean = False,
    tfevents_ttl: vh3.Integer = None,
    model_uid: vh3.String = None,
    model_scenario: vh3.String = None,
    produced_model_uid: vh3.String = None,
    timestamp: vh3.String = None,
    permissions: vh3.String = None,
    metrics: vh3.JSON = None,
    data: Union[vh3.File, vh3.JSON, vh3.MRTable, vh3.TSV, vh3.Text] = None,
    dataset_path: Union[vh3.MRDirectory, vh3.MRFile, vh3.MRTable] = None,
    report_url: vh3.JSON = None,
    tfevents: Sequence[Union[vh3.Binary, vh3.File, vh3.MRFile, vh3.MRTable, vh3.Text]] = ()
) -> PulsarAddInstanceOutput:
    """
    Pulsar: Add Instance

    Pulsar. [Wiki](https://wiki.yandex-team.ru/pulsar/). [Change log](https://a.yandex-team.ru/arc/trunk/arcadia/ml/pulsar/nirvana/nope_operations/add_instance_change_log.md).

    :param pulsar_token: Pulsar OAuth token
    :param model_options:
      [[Model options json.]]
      Model options json.
    :param dataset_info:
      [[Dataset info json.]]
      Dataset info json.
    :param user_datetime:
      [[Format: "%Y-%m-%d" or "%Y-%m-%d %H:%M:%S"]]
      Format: "%Y-%m-%d" or "%Y-%m-%d %H:%M:%S"
    :param per_object_data_metainfo:
      [[Format:
    ```
    [
        {
                "name": "name",  # required
                "type": "type",  # optional (default=none)
                "best_value": "Min",  # optional (default=none)
                "show": false,  # optional (default=true)
                "join_type": "inner",  # optional (default=none)
                "aggregate": true  # optional (default=false)
        },
        ...
    ]
    ```]]
      Format:
      ```
      [
        {
                "name": "name",  # required
                "type": "type",  # optional (default=none)
                "best_value": "Min",  # optional (default=none)
                "show": false,  # optional (default=true)
                "join_type": "inner",  # optional (default=none)
                "aggregate": true  # optional (default=false)
        },
        ...
      ]
      ```
    :param diff_tool_config:
      [[Format:
    ```
    {
            "group_order":  ['group_1', 'group_2', ...],
    }
    ```]]
      Format:
      ```
      {
              "group_order":  ['group_1', 'group_2', ...],
      }
      ```
    :param save_tfevents:
      [[If enable - tfevents will be saved as nirvana data to graph quota.]]
      If enable - tfevents will be saved as nirvana data to graph quota.
    :param tfevents_ttl: tfevents_ttl, Days
      [[tfevents ttl in days]]
      tfevents ttl in days
    :param timestamp: Timestamp for caching
      [[Any string used for Nirvana caching only]]
      Any string used for Nirvana caching only
    :param permissions:
      [[Format:
    ```
    {
        "read": ["Yandex", "@login"],
        "write": ["nirvana.user.yandex.staff"],
        "owner": ["@login"]
    }
    ```]]
      Format:
      ```
      {
          "read": ["Yandex", "@login"],
          "write": ["nirvana.user.yandex.staff"],
          "owner": ["@login"]
      }
      ```
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/fcf99a2d-500b-407f-8075-f94d5e54a50e")
@vh3.decorator.nirvana_output_names("json")
@vh3.decorator.nirvana_names_transformer(vh3.name_transformers.snake_to_dash, options=True)
def mr_read_json(
    *,
    yt_token: vh3.Secret,
    table: vh3.MRTable,
    ttl: vh3.Integer = 360,
    max_ram: vh3.Integer = 1024,
    max_disk: vh3.Integer = 1024,
    start_row: vh3.Integer = None,
    end_row: vh3.Integer = None,
    output_columns: vh3.MultipleStrings = (),
    output_format: vh3.Enum[Literal["ARRAY", "LINES"]] = "ARRAY",
    string_mode: vh3.Enum[Literal["TEXT", "BINARY"]] = "TEXT",
    timestamp: vh3.Date = None,
    sync: Sequence[
        Union[
            vh3.Binary,
            vh3.Executable,
            vh3.FMLDumpParse,
            vh3.FMLFormula,
            vh3.FMLFormulaSerpPrefs,
            vh3.FMLPool,
            vh3.FMLPrs,
            vh3.FMLSerpComparison,
            vh3.FMLWizards,
            vh3.File,
            vh3.HTML,
            vh3.HiveTable,
            vh3.Image,
            vh3.JSON,
            vh3.MRDirectory,
            vh3.MRFile,
            vh3.MRTable,
            vh3.TSV,
            vh3.Text,
            vh3.XML,
        ]
    ] = ()
) -> vh3.JSON:
    """
    MR Read JSON

    Reads an MR table (or a part of it) as JSON (either an array of JSON objects, or `
    `-delimited JSON objects)

    :param yt_token: YT Token:
      [[ID of Nirvana Secret with YT access token (https://nda.ya.ru/3RSzVU).
    Guide to Nirvana Secrets: https://nda.ya.ru/3RSzWZ]]
      YT OAuth Token.

        [Obtain access token](https://nda.ya.ru/3RSzVU), then [create a Nirvana secret](https://nda.ya.ru/3RSzWZ) and [use it here](https://nda.ya.ru/3RSzWb).
        You can [share the secret](https://nda.ya.ru/3RSzWd) with user(s) and/or a staff group.
    :param table:
      MR Table to read data from
    :param start_row: Start Row Index:
      [[Inclusive, counting from 0]]
      Start row index, **inclusive**, counting from `0`. If absent, table will be read from the beginning
    :param end_row: End Row Index:
      [[Exclusive, counting from 0]]
      End row index, **exclusive**, counting from `0`. If absent, table will be read to the end
    :param output_columns: Output Columns:
      [[Columns to output. If not specified, **all** table's columns will be used]]
      Columns to output. If not specified, **all** table's columns will be used
    :param output_format: Output Format:
      [["Array of JSON Objects" is used by robot-hitman's "YT Get".
    "
    -delimited JSON Objects" is more convenient to process using Unix text utilities (sed, awk, grep, jq etc.)]]
      Output Data Format.
      * **Array of JSON Objects** (`[ { ... }, ..., { ... } ]`)
      * **`
      `-delimited JSON Objects** (`{ ... }
       ...
       { ... }`)
    :param string_mode: String Mode:
      [["Text (recommended)" mode treats string column values as UTF-8 encoded text.

    "Binary Data" mode treats a string column values as raw binary data and converts them to JSON strings by mapping 0x00..0xFF byte values to \u0000..\u00FF characters.

    See https://nda.ya.ru/3SSRik for more information]]
      In **TEXT** mode (**`encode_utf8=%false`**), string column values are treated UTF-8 encoded text. Using this mode is **highly recommended**.

      In **BINARY** mode (**`encode_utf8=%true`**), string column values are treated as byte sequences and converted to JSON strings as follows:
      byte `0x00` maps to `\u0000`, ..., and `0xFF` maps to `\u00FF`.

      See [YT `json` Format Documentation](https://nda.ya.ru/3SSRik) for more information.
    :param timestamp: Timestamp:
      [[Set a recent, not previously used timestamp to force "MR Read" to run even if `table' was already read once]]
      Timestamp to control caching of "MR Read" results.

      Set a recent, not previously used timestamp to force "MR Read" to run even if `table` was already read once
    :param sync:
      Synchronization input. Can be used *e.g.* to read the table only after specific data is ready
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/6ef6b6f1-30c4-4115-b98c-1ca323b50ac0")
@vh3.decorator.nirvana_names(yt_token="yt-token", base_path="base_path")
@vh3.decorator.nirvana_output_names("outTable")
@vh3.decorator.nirvana_names_transformer(vh3.name_transformers.snake_to_camel)
def get_mr_table(
    *,
    cluster: vh3.Enum[
        Literal[
            "hahn",
            "banach",
            "freud",
            "marx",
            "hume",
            "arnold",
            "markov",
            "bohr",
            "landau",
            "seneca-vla",
            "seneca-sas",
            "seneca-man",
            "zeno",
        ]
    ] = None,
    creation_mode: vh3.Enum[Literal["NO_CHECK", "CHECK_EXISTS"]] = "NO_CHECK",
    table: vh3.String = None,
    yt_token: vh3.Secret = None,
    file_with_table_name: vh3.Text = None,
    base_path: Union[vh3.MRDirectory, vh3.MRFile, vh3.MRTable] = None
) -> vh3.MRTable:
    """
    Get MR Table

    Creates a reference to MR Table, either existing or potential.
      * If input `fileWithTableName` is present, its first line will be used as the table's path. If not, `table` option value will be used instead.
      * If `base_path` input is present, table path will be treated as *relative* and resolved against `base_path`. If not, path will be treated as *absolute*.

    :param cluster: Cluster:
      [[MR Cluster this table is on]]
      MR Cluster name, recognized by MR processor and FML processor.
      * If not set, `base_path`'s cluster will be used
      * If both `cluster` option value and `base_path` input are present, cluster name specified in **option** will be used
    :param creation_mode: Creation Mode:
      [[Actions to take when getting the MR Table]]
      MR Path creation mode. Specifies additional actions to be taken when getting the path
    :param table: Table:
      [[Path to MR Table]]
      Path to MR table. Used when `fileWithTableName` input is absent.
      * If `base_path` input is absent, this is an absolute path.
      * If `base_path` input is present, this is a relative path.
    :param yt_token: YT Token:
      [[(Optional) Token used if Creation Mode is "Check that Path Exists".
    Write the name of Nirvana Secret holding your YT Access Token here.]]
      *(Optional)* YT OAuth Token to use in "Check that Path Exists" Creation Mode. If not specified, MR Processor's token will be used.

      [Obtain access token](https://nda.ya.ru/3RSzVU), then [create a Nirvana secret](https://nda.ya.ru/3RSzWZ) and [use it here](https://nda.ya.ru/3RSzWb).
      You can [share the secret](https://nda.ya.ru/3RSzWd) with user(s) and/or a staff group.
    :param file_with_table_name:
      Text file with MR table path on its first line. If this input is absent, `table` option value will be used instead.
      * If `base_path` input is absent, this is an absolute path.
      * If `base_path` input is present, this is a relative path.
    :param base_path:
      Base path to resolve against.

      If absent, table path is considered absolute.
    """
    raise NotImplementedError("Write your local execution stub here")


class Python3DeepLearningOutput(NamedTuple):
    data: vh3.Binary
    state: vh3.Binary
    logs: vh3.Binary
    json_output: vh3.JSON


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/4c2e2df0-4dff-4cf8-b3ce-1f89bd62c9e8")
@vh3.decorator.nirvana_names(
    base_layer="base_layer",
    environment="Environment",
    install_pydl_package="install_pydl_package",
    run_command="run_command",
    openmpi_runner="openmpi_runner",
    openmpi_params="openmpi_params",
    mpi_processes_count="mpi_processes_count",
    before_run_command="before_run_command",
    after_run_command="after_run_command",
    ssh_key="ssh_key",
    auto_snapshot="auto_snapshot",
    nodes_count="nodes_count",
    additional_layers="additional_layers",
    user_requested_secret="user_requested_secret",
)
@vh3.decorator.nirvana_names_transformer(vh3.name_transformers.snake_to_dash, options=True)
def python_3_deep_learning(
    *,
    base_layer: vh3.Enum[
        Literal["PYDL_V3", "PYDL_V4", "PYDL_V5", "PYDL_V5_GPU", "PYDL_V5_GPU_NVIDIA", "NONE"]
    ] = "PYDL_V5_GPU_NVIDIA",
    environment: vh3.MultipleStrings = (),
    pip: vh3.MultipleStrings = (),
    install_pydl_package: vh3.Boolean = True,
    run_command: vh3.String = "python3 $SOURCE_CODE_PATH/__main__.py",
    cpu_cores_usage: vh3.Integer = 1600,
    gpu_count: vh3.Integer = 0,
    openmpi_runner: vh3.Boolean = False,
    openmpi_params: vh3.String = None,
    mpi_processes_count: vh3.Integer = -1,
    before_run_command: vh3.String = None,
    after_run_command: vh3.String = None,
    ttl: vh3.Integer = 1440,
    max_ram: vh3.Integer = 10000,
    max_disk: vh3.Integer = 10000,
    force_tmpfs_disk: vh3.Boolean = False,
    gpu_max_ram: vh3.Integer = 1024,
    gpu_type: vh3.Enum[
        Literal["NONE", "ANY", "CUDA_ANY", "CUDA_3_5", "CUDA_5_2", "CUDA_6_1", "CUDA_7_0", "CUDA_8_0"]
    ] = "NONE",
    strict_gpu_type: vh3.Boolean = False,
    ssh_key: vh3.Secret = None,
    yt_token: vh3.Secret = None,
    mr_account: vh3.String = None,
    auto_snapshot: vh3.Integer = 0,
    nodes_count: vh3.Integer = 1,
    additional_layers: vh3.MultipleStrings = (),
    retries_on_job_failure: vh3.Integer = 0,
    timestamp: vh3.Date = "2017-08-25T16:40:26+0300",
    debug_timeout: vh3.Integer = 0,
    user_requested_secret: vh3.Secret = None,
    pre_hook_enable: vh3.Boolean = True,
    post_hook_enable: vh3.Boolean = True,
    pre_hook_commands_json: vh3.MultipleStrings = (),
    post_hook_commands_json: vh3.MultipleStrings = (),
    job_host_tags: vh3.MultipleStrings = (),
    job_scheduler_instance: vh3.String = None,
    job_scheduler_yt_pool_tree: vh3.String = None,
    job_scheduler_yt_pool: vh3.String = None,
    job_scheduler_yt_token: vh3.Secret = None,
    job_mtn_enabled: vh3.Boolean = True,
    job_scheduler_yt_custom_spec: vh3.String = "{}",
    job_layer_yt_path: vh3.MultipleStrings = (),
    job_variables: vh3.MultipleStrings = (
        "LD_LIBRARY_PATH=/usr/local/cuda/lib64:/usr/local/cuda/lib64/stubs:/usr/local/cuda/extras/CUPTI/lib64",
    ),
    script: vh3.Binary = None,
    data: Sequence[vh3.Binary] = (),
    state: vh3.Binary = None,
    volume: Sequence[vh3.Binary] = (),
    params: vh3.JSON = None
) -> Python3DeepLearningOutput:
    """
    Python 3 Deep Learning

    Python code runner with support of tensorflow, numpy, theano, torch, keras and nirvana_dl library. See https://wiki.yandex-team.ru/computervision/projects/deeplearning/nirvanadl/ for user manual.

    :param base_layer: Base porto layer
    :param pip: Libraries to Install
      [[List of libraries to be installed using pip install. Some libraries are already available,
      see https://wiki.yandex-team.ru/computervision/projects/deeplearning/nirvanadl/ for details. WARNING: use only with explicit version for reproducibility.]]
    :param install_pydl_package: Install nirvana-dl package
    :param run_command: Run command
      [[Custom bash code]]
    :param openmpi_runner: use openmpi runner
    :param openmpi_params: openmpi runner extra args
    :param before_run_command: Before run command
      [[Command which will be executed before run_command]]
    :param after_run_command: After run command
      [[Command which will be executed after run command]]
    :param strict_gpu_type: strict GPU type
    :param ssh_key: SSH Key
      [[Secret with ssh private key to sync logs with remote server]]
    :param yt_token: YT Token
      [[ID of Nirvana Secret with YT access token (https://nda.ya.ru/3RSzVU). Guide to Nirvana Secrets: https://nda.ya.ru/3RSzWZ]]
    :param mr_account: MR Account:
      [[MR Account Name. By default, output tables and directories will be created in some subdirectory of home/<MR Account>/<workflow owner>/nirvana]]
    :param auto_snapshot: Auto Snapshot
      [[Time interval (minutes) to dump snapshots automatically, without explicit python method call. May cause race condition. If 0, option will be disabled]]
    :param nodes_count: Full number of nodes:
      [[Number of nodes. Should be >= 1]]
      Number of nodes. Should be >= 1
    :param additional_layers: Additional porto layers
      [[IDs of porto layers to put on top of base layer]]
    :param timestamp: Timestamp
    :param job_host_tags: master-job-host-tags
    :param job_mtn_enabled:
      https://st.yandex-team.ru/NIRVANA-12358#5eda1eeb6213d14744d9d791
    :param script:
      Tar-archive with source code inside. Unpacked archive will be available by SOURCE_CODE_PATH environment variable.
    :param data:
      Tar archive(s) with various data. Unpacked data will be available by INPUT_PATH environment variable.
      Multiple archives will be concatenated.
    :param state:
      Saved state of the process, will be used as "state" output snapshot.
    :param volume:
      Additional porto volume(s).
    :param params:
      JSON with additional parameters that can be used in your program.
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/86670fb6-6c9a-4cd3-8802-6fcd745b818e")
@vh3.decorator.nirvana_output_names("code")
@vh3.decorator.nirvana_names_transformer(vh3.name_transformers.snake_to_dash, options=True)
def arc_export_not_deterministic(
    *,
    arc_token: vh3.Secret,
    path: vh3.String,
    ttl: vh3.Integer = 360,
    max_ram: vh3.Integer = 256,
    max_disk: vh3.Integer = 1024,
    retries_on_job_failure: vh3.Integer = 0,
    reference: vh3.String = "trunk"
) -> vh3.Binary:
    """
    Arc export (not deterministic)

    Checkouts an arc branch to an archive

    :param reference: Reference
      [[Arc commit or branch name or revision]]
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/961eda13-7e75-4e8e-96aa-fa43c1dd97c1")
@vh3.decorator.nirvana_names(max_disk="max-disk")
@vh3.decorator.nirvana_output_names("archive")
def create_tar_archive_10(
    *,
    ttl: vh3.Integer = 360,
    max_disk: vh3.Integer = 1024,
    name0: vh3.String = None,
    name1: vh3.String = None,
    name2: vh3.String = None,
    name3: vh3.String = None,
    name4: vh3.String = None,
    name5: vh3.String = None,
    name6: vh3.String = None,
    name7: vh3.String = None,
    name8: vh3.String = None,
    name9: vh3.String = None,
    tar_mode: vh3.Enum[Literal["none", "extract", "subdir"]] = "extract",
    compress: vh3.Enum[
        Literal["--no-auto-compress", "--gzip", "--bzip2", "--xz", "--lzip", "--lzma", "--lzop"]
    ] = "--no-auto-compress",
    file0: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file1: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file2: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file3: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file4: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file5: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file6: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file7: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file8: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None,
    file9: Union[vh3.Binary, vh3.Executable, vh3.HTML, vh3.Image, vh3.JSON, vh3.TSV, vh3.Text, vh3.XML] = None
) -> vh3.Binary:
    """
    Create TAR archive 10

    Create TAR archive from given binary files. If the files are archives themselves, unpack them.

    :param name0: File name 0
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name1: File name 1
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name2: File name 2
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name3: File name 3
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name4: File name 4
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name5: File name 5
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name6: File name 6
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name7: File name 7
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name8: File name 8
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param name9: File name 9
      [[Ignored if corresponding file is tar archive]]
      Ignored if corresponding file is tar archive
    :param tar_mode: Tar processing mode
      [[Action for input tar archives]]
      Action for input tar archives
    :param compress: Tar compress
      [[Tar compress mode]]
      Tar compress mode
    :param file0:
      File or archive
    :param file1:
      File or archive
    :param file2:
      File or archive
    :param file3:
      File or archive
    :param file4:
      File or archive
    :param file5:
      File or archive
    :param file6:
      File or archive
    :param file7:
      File or archive
    :param file8:
      File or archive
    :param file9:
      File or archive
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/31d7bcd4-c5f4-4398-9bf1-070e5466c219")
@vh3.decorator.nirvana_output_names("tar_archive")
@vh3.decorator.nirvana_names_transformer(vh3.name_transformers.snake_to_dash, options=True)
def merge_tar_archives(
    *,
    tar_archives: Sequence[vh3.Binary],
    ttl: vh3.Integer = 360,
    max_ram: vh3.Integer = 100,
    max_disk: vh3.Integer = 24576
) -> vh3.Binary:
    """
    Merge tar archives

    Объединяет содержимое нескольких архивов в один. На выходе возвращает tar.

    :param tar_archives:
      Tar archives to merge
    """
    raise NotImplementedError("Write your local execution stub here")


class PulsarUpdateInstanceOutput(NamedTuple):
    info: vh3.JSON
    link: vh3.HTML


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/7d8dfc84-8787-463a-b246-966b3a9f632b")
def pulsar_update_instance(
    *,
    pulsar_token: vh3.Secret,
    instance_id: vh3.String,
    model_options: vh3.String = None,
    dataset_info: vh3.String = None,
    tags: vh3.MultipleStrings = (),
    user_datetime: vh3.String = None,
    name: vh3.String = None,
    description: vh3.String = None,
    experiment_id: vh3.String = None,
    links: vh3.String = None,
    per_object_data_metainfo: vh3.String = None,
    diff_tool_config: vh3.String = None,
    save_tfevents: vh3.Boolean = False,
    tfevents_ttl: vh3.Integer = None,
    model_uid: vh3.String = None,
    model_scenario: vh3.String = None,
    produced_model_uid: vh3.String = None,
    permissions: vh3.String = None,
    metrics: vh3.JSON = None,
    data: Union[vh3.File, vh3.JSON, vh3.MRTable, vh3.TSV, vh3.Text] = None,
    report_url: vh3.JSON = None,
    tfevents: Sequence[Union[vh3.Binary, vh3.File, vh3.MRFile, vh3.MRTable, vh3.Text]] = ()
) -> PulsarUpdateInstanceOutput:
    """
    Pulsar: Update Instance

    Pulsar. [Wiki](https://wiki.yandex-team.ru/pulsar/). [Change log](https://a.yandex-team.ru/arc/trunk/arcadia/ml/pulsar/nirvana/nope_operations/update_instance_change_log.md).

    :param pulsar_token: Pulsar OAuth token
    :param per_object_data_metainfo:
      [[Format:
    ```
    [
        {
                "name": "name",  # required
                "type": "type",  # optional (default=none)
                "best_value": "Min",  # optional (default=none)
                "show": false,  # optional (default=true)
                "join_type": "inner",  # optional (default=none)
                "aggregate": true,  # optional (default=false)
                "title": "title",  # optional (default=none)
                "tooltip": "tooltip",  # optional (default=none)
                "group_id": "group_1",  # optional (default=none)
        },
        ...
    ]
    ```]]
      Format:
      ```
      [
        {
                "name": "name",  # required
                "type": "type",  # optional (default=none)
                "best_value": "Min",  # optional (default=none)
                "show": false,  # optional (default=true)
                "join_type": "inner",  # optional (default=none)
                "aggregate": true,  # optional (default=false)
                "title": "title",  # optional (default=none)
                "tooltip": "tooltip",  # optional (default=none)
                "group_id": "group_1",  # optional (default=none)
        },
        ...
      ]
      ```
    :param diff_tool_config:
      [[Format:
    ```
    {
            "group_order":  ['group_1', 'group_2', ...],
    }
    ```]]
      Format:
      ```
      {
              "group_order":  ['group_1', 'group_2', ...],
      }
      ```
    :param save_tfevents:
      [[If enable - tfevents will be saved as nirvana data to graph quota.]]
      If enable - tfevents will be saved as nirvana data to graph quota.
    :param tfevents_ttl: tfevents_ttl, Days
      [[tfevents ttl in days]]
      tfevents ttl in days
    :param permissions:
      [[Format:
    ```
    {
        "read": ["Yandex", "@login"],
        "write": ["nirvana.user.yandex.staff"],
        "owner": ["@login"]
    }
    ```]]
      Format:
      ```
      {
          "read": ["Yandex", "@login"],
          "write": ["nirvana.user.yandex.staff"],
          "owner": ["@login"]
      }
      ```
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/59fe50c4-f293-4c2b-acf1-ff0c703d3f50")
@vh3.decorator.nirvana_names(max_disk="max-disk")
@vh3.decorator.nirvana_output_names("resource")
def get_sandbox_resource(
    *, resource_id: vh3.String, ttl: vh3.Integer = 360, max_disk: vh3.Integer = 2048, do_pack: vh3.Boolean = False
) -> vh3.Binary:
    """
    Get sandbox resource

    Download resource from sandbox

    :param resource_id: Resource id
      Sandbox resource id to download
    :param do_pack: Do pack
      [[Упаковать скачанные ресурсы в один файл, актуально для директорий]]
      Упаковать скачанные ресурсы в один файл, актуально для директорий
    """
    raise NotImplementedError("Write your local execution stub here")


class TrafficSignsDatasetPrepareOutput(NamedTuple):
    train_tfrecord: vh3.Binary
    test_tfrecord: vh3.OptionalOutput[vh3.Binary]
    label_map: vh3.Binary


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/8a6e9b76-e468-423a-a622-9219119e60e1")
@vh3.decorator.nirvana_names(yt_token="yt-token", max_ram="max-ram")
def traffic_signs_dataset_prepare(
    *,
    yt_token: vh3.Secret,
    input_table: vh3.String,
    input_table_cache_date: vh3.String,
    arcadia_revision: vh3.Integer = None,
    arcadia_patch: vh3.String = None,
    input_test_table: vh3.String = None,
    min_size: vh3.Integer = None,
    min_amount: vh3.Integer = None,
    train_part: vh3.Number = None,
    join_speed_limits: vh3.Boolean = False,
    augm_flip_horz: vh3.Boolean = False,
    blur_fliped: vh3.Boolean = False,
    filter_class_table: vh3.String = None,
    rename_class_table: vh3.String = None,
    max_ram: vh3.Integer = 1000
) -> TrafficSignsDatasetPrepareOutput:
    """
    TrafficSigns dataset prepare

    из таблицы YT с разметкой дорожных знаков на изображениях готовит два файла в формате tfrecord (тренировочный и тестовый), а также файл соответствия индексов и названий классов

    :param yt_token: YT Token:
      [[ID of Nirvana Secret with YT access token (https://nda.ya.ru/3RSzVU). Guide to Nirvana Secrets: https://nda.ya.ru/3RSzWZ]]
    :param input_table: Input table:
      [[Input YT table name]]
    :param arcadia_revision: Arcadia Revision
    :param arcadia_patch: Apply patch
      [[Diff file rbtorrent, paste.y-t.ru link or plain text. Doc: https://nda.ya.ru/3QTTV4]]
    :param min_size: Min signs size:
      [[Minimal value of size (width or height) of signs]]
    :param min_amount: Min amount:
      [[Minimal amount of insances of class]]
    :param train_part: Train part:
      [[Part of dataset for building train.tfrecord (from 0. to 1.0) other part will use for test.tfrecord]]
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/58d8d7a2-a7a2-44da-8402-a503472d593e")
@vh3.decorator.nirvana_names(max_ram="max-ram")
@vh3.decorator.nirvana_output_names("timestamp")
def get_timestamp_now(
    *,
    ttl: vh3.Integer = 360,
    max_ram: vh3.Integer = 100,
    timestamp_type: vh3.Enum[Literal["string", "integer"]] = "string",
    key_name: vh3.String = "timestamp",
    format: vh3.String = "%s"
) -> vh3.JSON:
    """
    Get Timestamp Now

    Get json of the form {KEY_NAME: TIME_NOW}

    :param timestamp_type: Timestamp type
    :param key_name: Key name
      [[Name of the timestamp key in resulting json]]
    """
    raise NotImplementedError("Write your local execution stub here")
