Утилита оценивает качество детектирования объектов и качество кластеризации.

### Оценка качества детектирования

На вход подаётся два файла c объектами в одинаковом json [формате](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/readme.md).
Первый файл содержит эталонную разметку дорожных знаков на фотографиях.
Второй файл содержит тестовые данные (например, результат работы детектора).
Для оценки качества вычисляем точность и полноту.

_*Замечание.* object_id объектов в первом и во втором файле не связаны. Вообще говоря, object_id уникален внутри одной фотографии в одном файле._

Два объекта на фотографии считаются совпадающими, если у них одинаковый тип (параметр 'type' в json) и *intersection over union* их bbox-ов
больше порога, задаваемого параметром командной строки.

Если в тестовом наборе отсутствует объект, который есть в эталонном наборе, но у этого объекта в эталонном наборе размер по обеим осям меньше
порога (задаваемого параметром командной строки), то такой объект не считается false negative и за него не начисляется штраф.

### Оценка качества кластеризации

Этот же инструмент может использоваться для оценки качества кластеризации, в этом случае на вход подаются два файла с кластерами в json [формате](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/readme.md),
*feature_id* и *object_id* соответствуют объектам в файле детекций.

При этом в любом случае должен быть передан файл с эталонной разметкой объектов, чтобы применить фильтры по размеру и типам объекта. Если
передан файл с тестовой разметкой, то строится карта соответствия ID объектов в GT и тестовом наборах, если файл не передан, то считается,
что ID объектов в обоих файлах кластеров одинаковые.

### Аргументы командной строки

1. ```--gt-objects``` - файл с эталонной разметкой объектов на фотографиях

2. ```--gt-clusters``` - файл с эталонным набором кластеров

3. ```--test-objects``` - файл с тестовой разметкой (результатами детектора)

4. ```--test-clusters``` - файл с тестовым набором кластеров

5. ```--iou-thresh``` - порог IoU начиная с которого объекты считаются совпадающими (по умолчанию 0.5)

6. ```--min-bbox-size``` - если размер bbox-а объекта по обеим осям меньше значения данного параметра, то за его "ненахождение" детектор не штрафуем. При кластеризации, объекты меньше данного размера выбрасываются из кластеров.

7. ```--valid-classes-list``` - путь к файлу со списком классов знаков, если задан, то из файлов с разметкой считываются только объекты тех классов, которые есть в списке
