#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/clusters.h>

namespace maps::mrc::eye::datasets {

namespace {

static constexpr const char* CLUSTER_ID = "cluster_id";
static constexpr const char* OBJECTS = "objects";
static constexpr const char* FEATURE_ID = "feature_id";
static constexpr const char* OBJECT_ID = "object_id";

} // namespace

bool operator==(const FeatureObjectId& lhs, const FeatureObjectId& rhs) {
    return std::tuple(lhs.featureId, lhs.objectId)
        == std::tuple(rhs.featureId, rhs.objectId);
}


template<>
std::tuple<db::TId, Cluster> fromJson(const json::Value& item) {
    Cluster cluster;
    for (const json::Value& objectJson : item[OBJECTS]) {
        cluster.push_back({
            objectJson[FEATURE_ID].as<db::TId>(),
            objectJson[OBJECT_ID].as<db::TId>(),
        });
    };

    return {
        item[CLUSTER_ID].as<db::TId>(),
        std::move(cluster)
    };
}

template<>
json::Value toJson(const db::TId& clusterId, const Cluster& cluster) {
    std::vector<json::Value> clusterJson;
    for (const auto& [featureId, objectId] : cluster) {
        json::repr::ObjectRepr objectContent{
            {FEATURE_ID, json::Value(featureId)},
            {OBJECT_ID, json::Value(objectId)}
        };
        clusterJson.push_back(json::Value(objectContent));
    }

    json::repr::ObjectRepr content{
        {CLUSTER_ID, json::Value(clusterId)},
        {OBJECTS, json::Value(clusterJson)},
    };

    return json::Value(content);
}


template<>
std::tuple<db::TId, Cluster> fromNode(const NYT::TNode& node) {
    Cluster cluster;
    for (const NYT::TNode& objectNode : node[OBJECTS].AsList()) {
        cluster.push_back({
            objectNode[FEATURE_ID].AsInt64(),
            objectNode[OBJECT_ID].AsInt64(),
        });
    }

    return {
        node[CLUSTER_ID].AsInt64(),
        std::move(cluster)
    };
}

template<>
NYT::TNode toNode(const db::TId& clusterId, const Cluster& cluster) {
    NYT::TNode clusterNode = NYT::TNode::CreateList();
    for (const auto& [featureId, objectId] : cluster) {
        clusterNode.Add(
            NYT::TNode()
            (FEATURE_ID, featureId)
            (OBJECT_ID, objectId)
        );
    }

    return NYT::TNode()
        (CLUSTER_ID, clusterId)
        (OBJECTS, clusterNode);
}


const NYT::TNode ClusterYTSchemaWrap::SCHEMA = NYT::TTableSchema()
    .AddColumn(CLUSTER_ID, NYT::EValueType::VT_INT64)
    .AddColumn(OBJECTS, NYT::EValueType::VT_ANY).ToNode();

} // namespace maps::mrc::eye::datasets
