#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/images.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/objects.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/matches.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/clusters.h>

#include <maps/libs/common/include/exception.h>

namespace maps::mrc::eye::datasets {

namespace {

constexpr maps::enum_io::Representations<DatasetType> DATASET_TYPE_ENUM_REPRESENTATION {
    {DatasetType::Images, "images"},
    {DatasetType::Objects, "objects"},
    {DatasetType::Matches, "matches"},
    {DatasetType::Clusters, "clusters"},
};

} // namespace

DEFINE_ENUM_IO(DatasetType, DATASET_TYPE_ENUM_REPRESENTATION);


BaseDatasetPtr createDataset(DatasetType type) {
    switch (type) {
        case DatasetType::Images:
            return std::make_unique<ImagesDataset>();
        case DatasetType::Objects:
            return std::make_unique<ObjectsDataset>();
        case DatasetType::Matches:
            return std::make_unique<MatchesDataset>();
        case DatasetType::Clusters:
            return std::make_unique<ClustersDataset>();
        default:
            throw maps::RuntimeError() << "Unknown dataset type: " << toString(type);
    }
}

} // namespace maps::mrc::eye::datasets
