#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/images.h>

namespace maps::mrc::eye::datasets {

namespace {

static constexpr const char* FEATURE_ID = "feature_id";
static constexpr const char* IMAGE = "image";

} // namespace

template<>
std::tuple<db::TId, std::string> fromJson(const json::Value& item) {
    return {
        item[FEATURE_ID].as<db::TId>(),
        item[IMAGE].as<std::string>()
    };
}
template<>
json::Value toJson(const db::TId& featureId, const std::string& base64Image) {
    json::repr::ObjectRepr content{
        {FEATURE_ID, json::Value(featureId)},
        {IMAGE, json::Value(base64Image)},
    };

    return json::Value(content);
}

template<>
std::tuple<db::TId, std::string> fromNode(const NYT::TNode& node) {
    return std::tuple<db::TId, std::string>{
        node[FEATURE_ID].AsInt64(),
        node[IMAGE].AsString()
    };
}
template<>
NYT::TNode toNode(const db::TId& featureId, const std::string& base64Image) {
    return NYT::TNode()
        (FEATURE_ID, featureId)
        (IMAGE, TString(base64Image));
}


const NYT::TNode ImageYTSchemaWrap::SCHEMA = NYT::TTableSchema()
    .AddColumn(FEATURE_ID, NYT::EValueType::VT_INT64)
    .AddColumn(IMAGE, NYT::EValueType::VT_STRING).ToNode();

} // namespace maps::mrc::eye::datasets
