#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>

#include <library/cpp/yson/node/node.h>
#include <maps/libs/json/include/value.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <vector>
#include <tuple>

namespace maps::mrc::eye::datasets {

struct FeatureObjectId {
    db::TId featureId;
    db::TId objectId;
};

bool operator==(const FeatureObjectId& lhs, const FeatureObjectId& rhs);

using Cluster = std::vector<FeatureObjectId>;


template<>
std::tuple<db::TId, Cluster> fromJson(const json::Value& item);
template<>
json::Value toJson(const db::TId& clusterId, const Cluster& cluster);
template<>
std::tuple<db::TId, Cluster> fromNode(const NYT::TNode& node);
template<>
NYT::TNode toNode(const db::TId& clusterId, const Cluster& cluster);


struct ClusterHeaderWrap {
    static constexpr const char* HEADER = "clusters";
};

struct ClusterYTSchemaWrap {
    static const NYT::TNode SCHEMA;
};


using ClustersDataset = Dataset<db::TId, Cluster, ClusterHeaderWrap, ClusterYTSchemaWrap>;

} // namespace maps::mrc::eye::datasets
