#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>

#include <library/cpp/yson/node/node.h>
#include <maps/libs/json/include/value.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <string>
#include <tuple>

namespace maps::mrc::eye::datasets {

template<>
std::tuple<db::TId, std::string> fromJson(const json::Value& item);
template<>
json::Value toJson(const db::TId& featureId, const std::string& base64Image);
template<>
std::tuple<db::TId, std::string> fromNode(const NYT::TNode& node);
template<>
NYT::TNode toNode(const db::TId& featureId, const std::string& base64Image);


struct ImageHeaderWrap {
    static constexpr const char* HEADER = "features_image";
};

struct ImageYTSchemaWrap {
    static const NYT::TNode SCHEMA;
};


using ImagesDataset = Dataset<db::TId, std::string, ImageHeaderWrap, ImageYTSchemaWrap>;

} // namespace maps::mrc::eye::datasets
