#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>

#include <maps/libs/enum_io/include/enum_io.h>

#include <mapreduce/yt/interface/client.h>

#include <string>

namespace maps::mrc::eye::datasets {

enum class Action {
    Download,
    Upload,
};

DECLARE_ENUM_IO(Action);

class DatasetManager {
public:
    DatasetManager(NYT::IClientPtr client);

    void perform(
        Action action, DatasetType datasetType,
        const std::string& jsonPath, const std::string& tablePath);

private:
    NYT::IClientPtr client_;
};

} // namespace maps::mrc::eye::datasets
