#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>

#include <library/cpp/yson/node/node.h>
#include <maps/libs/json/include/value.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <vector>
#include <tuple>

namespace maps::mrc::eye::datasets {

using FeatureIdPair = std::pair<db::TId, db::TId>;

struct Match {
    db::TId objectId1;
    db::TId objectId2;
};

bool operator==(const Match& lhs, const Match& rhs);

using Matches = std::vector<Match>;


template<>
std::tuple<FeatureIdPair, Matches> fromJson(const json::Value& item);
template<>
json::Value toJson(const FeatureIdPair& featureIdPair, const Matches& matches);
template<>
std::tuple<FeatureIdPair, Matches> fromNode(const NYT::TNode& node);
template<>
NYT::TNode toNode(const FeatureIdPair& featureIdPair, const Matches& matches);


struct MatchHeaderWrap {
    static constexpr const char* HEADER = "features_pairs";
};

struct MatchYTSchemaWrap {
    static const NYT::TNode SCHEMA;
};


using MatchesDataset = Dataset<FeatureIdPair, Matches, MatchHeaderWrap, MatchYTSchemaWrap>;

} // namespace maps::mrc::eye::datasets
