#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>

#include <maps/wikimap/mapspro/services/mrc/libs/traffic_signs/include/yandex/maps/mrc/traffic_signs/signs.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/image_box.h>

#include <library/cpp/yson/node/node.h>
#include <maps/libs/json/include/value.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <vector>
#include <tuple>

namespace maps::mrc::eye::datasets {

struct Object {
    db::TId objectId;
    common::ImageBox bbox;
    traffic_signs::TrafficSign type;
};

bool operator==(const Object& lhs, const Object& rhs);

using Objects = std::vector<Object>;


template<>
std::tuple<db::TId, Objects> fromJson(const json::Value& item);
template<>
json::Value toJson(const db::TId& featureId, const Objects& objects);
template<>
std::tuple<db::TId, Objects> fromNode(const NYT::TNode& node);
template<>
NYT::TNode toNode(const db::TId& featureId, const Objects& objects);


struct ObjectHeaderWrap {
    static constexpr const char* HEADER = "features_objects";
};

struct ObjectYTSchemaWrap {
    static const NYT::TNode SCHEMA;
};


using ObjectsDataset = Dataset<db::TId, Objects, ObjectHeaderWrap, ObjectYTSchemaWrap>;

} // namespace maps::mrc::eye::datasets
