#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/clusters.h>

#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::eye::datasets::tests {

Y_UNIT_TEST_SUITE(clusters_tests)
{

Y_UNIT_TEST(item_yt)
{
    const db::TId clusterId = 1;
    const Cluster cluster{{1, 2}, {3, 5}};

    NYT::TNode node = toNode(clusterId, cluster);

    const auto& [resultClusterId, resultCluster]
        = fromNode<db::TId, Cluster>(node);

    EXPECT_EQ(clusterId, resultClusterId);
    EXPECT_TRUE(cluster == resultCluster);
}

Y_UNIT_TEST(item_json)
{
    const db::TId clusterId = 1;
    const Cluster cluster{{1, 2}, {3, 5}};

    json::Value value = toJson(clusterId, cluster);

    const auto& [resultClusterId, resultCluster]
        = fromJson<db::TId, Cluster>(value);

    EXPECT_EQ(clusterId, resultClusterId);
    EXPECT_TRUE(cluster == resultCluster);
}

Y_UNIT_TEST(write_read_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const ClustersDataset dataset({
        {1, Cluster{{1, 2}, {3, 5}}},
        {2, Cluster{{0, 2}, {2, 4}}},
    });
    dataset.writeToYT(client, tablePath);

    ClustersDataset resultDataset;
    resultDataset.readFromYT(client, tablePath);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

Y_UNIT_TEST(write_read_json)
{
    const ClustersDataset dataset({
        {1, Cluster{{1, 2}, {3, 5}}},
        {2, Cluster{{0, 2}, {2, 4}}},
    });
    std::stringstream ss;
    dataset.writeToJson(ss);

    ClustersDataset resultDataset;
    resultDataset.readFromJson(ss);

    EXPECT_EQ(dataset.data(), resultDataset.data());
}

Y_UNIT_TEST(upload_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const ClustersDataset dataset({
        {1, Cluster{{1, 2}, {3, 5}}},
        {2, Cluster{{0, 2}, {2, 4}}},
    });
    std::stringstream ss;
    dataset.writeToJson(ss);

    ClustersDataset::uploadToYT(client, ss, tablePath);

    ClustersDataset resultDataset;
    resultDataset.readFromYT(client, tablePath);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

Y_UNIT_TEST(download_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const ClustersDataset dataset({
        {1, Cluster{{1, 2}, {3, 5}}},
        {2, Cluster{{0, 2}, {2, 4}}},
    });
    dataset.writeToYT(client, tablePath);

    std::stringstream ss;
    ClustersDataset::downloadFromYT(client, ss, tablePath);

    ClustersDataset resultDataset;
    resultDataset.readFromJson(ss);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::datasets::tests
