#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/images.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/objects.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/matches.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::eye::datasets::tests {

Y_UNIT_TEST_SUITE(dataset_tests)
{

Y_UNIT_TEST(convert_dataset_type)
{
    EXPECT_EQ(toString(DatasetType::Images), "images");
    EXPECT_EQ(toString(DatasetType::Objects), "objects");
    EXPECT_EQ(toString(DatasetType::Matches), "matches");
    EXPECT_EQ(toString(DatasetType::Clusters), "clusters");

    DatasetType type;
    fromString("images", type);
    EXPECT_EQ(type, DatasetType::Images);
    fromString("objects", type);
    EXPECT_EQ(type, DatasetType::Objects);
    fromString("matches", type);
    EXPECT_EQ(type, DatasetType::Matches);
    fromString("clusters", type);
    EXPECT_EQ(type, DatasetType::Clusters);
}

Y_UNIT_TEST(create_dataset)
{
    EXPECT_TRUE(dynamic_cast<ImagesDataset*>(createDataset(DatasetType::Images).get()) != nullptr);
    EXPECT_TRUE(dynamic_cast<ObjectsDataset*>(createDataset(DatasetType::Objects).get()) != nullptr);
    EXPECT_TRUE(dynamic_cast<MatchesDataset*>(createDataset(DatasetType::Matches).get()) != nullptr);
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::datasets::tests
