#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/images.h>

#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::eye::datasets::tests {

Y_UNIT_TEST_SUITE(images_tests)
{

Y_UNIT_TEST(item_yt)
{
    const db::TId featureId = 1;
    const std::string base64Image = "image";

    NYT::TNode node = toNode(featureId, base64Image);

    const auto& [resultFeatureId, resultBase64Image]
        = fromNode<db::TId, std::string>(node);

    EXPECT_EQ(featureId, resultFeatureId);
    EXPECT_EQ(base64Image, resultBase64Image);
}

Y_UNIT_TEST(item_json)
{
    const db::TId featureId = 1;
    const std::string base64Image = "image";

    json::Value value = toJson(featureId, base64Image);

    const auto& [resultFeatureId, resultBase64Image]
        = fromJson<db::TId, std::string>(value);

    EXPECT_EQ(featureId, resultFeatureId);
    EXPECT_EQ(base64Image, resultBase64Image);
}

Y_UNIT_TEST(write_read_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const ImagesDataset dataset({
        {1, "image1"},
        {2, "image2"}
    });
    dataset.writeToYT(client, tablePath);

    ImagesDataset resultDataset;
    resultDataset.readFromYT(client, tablePath);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

Y_UNIT_TEST(write_read_json)
{
    const ImagesDataset dataset({
        {1, "image1"},
        {2, "image2"}
    });
    std::stringstream ss;
    dataset.writeToJson(ss);

    ImagesDataset resultDataset;
    resultDataset.readFromJson(ss);

    EXPECT_EQ(dataset.data(), resultDataset.data());
}

Y_UNIT_TEST(upload_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const ImagesDataset dataset({
        {1, "image1"},
        {2, "image2"}
    });
    std::stringstream ss;
    dataset.writeToJson(ss);

    ImagesDataset::uploadToYT(client, ss, tablePath);

    ImagesDataset resultDataset;
    resultDataset.readFromYT(client, tablePath);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

Y_UNIT_TEST(download_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const ImagesDataset dataset({
        {1, "image1"},
        {2, "image2"}
    });
    dataset.writeToYT(client, tablePath);

    std::stringstream ss;
    ImagesDataset::downloadFromYT(client, ss, tablePath);

    ImagesDataset resultDataset;
    resultDataset.readFromJson(ss);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::datasets::tests
