#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/dataset.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/lib/datasets/include/matches.h>

#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::eye::datasets::tests {

Y_UNIT_TEST_SUITE(matches_tests)
{

Y_UNIT_TEST(item_yt)
{
    const FeatureIdPair featureIdPair = {1, 2};
    const Matches matches{{1, 2}, {3, 5}};

    NYT::TNode node = toNode(featureIdPair, matches);

    const auto& [resultFeatureIdPair, resultMatches]
        = fromNode<FeatureIdPair, Matches>(node);

    EXPECT_EQ(featureIdPair, resultFeatureIdPair);
    EXPECT_TRUE(matches == resultMatches);
}

Y_UNIT_TEST(item_json)
{
    const FeatureIdPair featureIdPair = {1, 2};
    const Matches matches{{1, 2}, {3, 5}};

    json::Value value = toJson(featureIdPair, matches);

    const auto& [resultFeatureIdPair, resultMatches]
        = fromJson<FeatureIdPair, Matches>(value);

    EXPECT_EQ(featureIdPair, resultFeatureIdPair);
    EXPECT_TRUE(matches == resultMatches);
}

Y_UNIT_TEST(write_read_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const MatchesDataset dataset({
        {{1, 2}, Matches{{1, 2}, {3, 5}}},
        {{4, 3}, Matches{{0, 2}, {2, 4}}},
    });
    dataset.writeToYT(client, tablePath);

    MatchesDataset resultDataset;
    resultDataset.readFromYT(client, tablePath);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

Y_UNIT_TEST(write_read_json)
{
    const MatchesDataset dataset({
        {{1, 2}, Matches{{1, 2}, {3, 5}}},
        {{4, 3}, Matches{{0, 2}, {2, 4}}},
    });
    std::stringstream ss;
    dataset.writeToJson(ss);

    MatchesDataset resultDataset;
    resultDataset.readFromJson(ss);

    EXPECT_EQ(dataset.data(), resultDataset.data());
}

Y_UNIT_TEST(upload_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const MatchesDataset dataset({
        {{1, 2}, Matches{{1, 2}, {3, 5}}},
        {{4, 3}, Matches{{0, 2}, {2, 4}}},
    });
    std::stringstream ss;
    dataset.writeToJson(ss);

    MatchesDataset::uploadToYT(client, ss, tablePath);

    MatchesDataset resultDataset;
    resultDataset.readFromYT(client, tablePath);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

Y_UNIT_TEST(download_yt)
{
    NYT::IClientPtr client = NYT::NTesting::CreateTestClient();
    const std::string tablePath = "//home/dataset";
    const MatchesDataset dataset({
        {{1, 2}, Matches{{1, 2}, {3, 5}}},
        {{4, 3}, Matches{{0, 2}, {2, 4}}},
    });
    dataset.writeToYT(client, tablePath);

    std::stringstream ss;
    MatchesDataset::downloadFromYT(client, ss, tablePath);

    MatchesDataset resultDataset;
    resultDataset.readFromJson(ss);

    EXPECT_EQ(dataset.data(), resultDataset.data());

    client->Remove(NYT::TYPath(tablePath));
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::datasets::tests
