#!/usr/bin/python3
# -*- coding: utf-8 -*-

import yt.wrapper as yt

import argparse
import json


def get_args():
    parser = argparse.ArgumentParser(description='Export matches from yt table to json file')

    parser.add_argument('--yt-proxy', dest='yt_proxy', default='hahn')

    parser.add_argument('--match-table', dest='match_table', type=str, required=True)

    parser.add_argument('--out-file', type=str, required=True)

    return parser.parse_args()


def main():
    args = get_args()
    ytClient = yt.YtClient(proxy=args.yt_proxy)

    data = {'features_pairs': list(ytClient.read_table(args.match_table))}

    with open(args.out_file, 'w') as out:
        json.dump(data, out)


if __name__ == "__main__":
    main()
