#include "util.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::mrc::eye::pov {


int64_t getRowsCount(
    const NYT::IClientPtr ytClient,
    const std::string& path)
{
    return ytClient->Get(TString(path) + "/@row_count").AsInt64();
}


bool belongsToSamePassage(const db::Feature& feature1, const db::Feature& feature2)
{
    return feature1.sourceId() == feature2.sourceId() &&
        std::chrono::abs(feature1.timestamp() - feature2.timestamp())
            < std::chrono::seconds(300);
}


} // namespace maps::mrc::eye::pov


