#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/keypoints.h>
#include <maps/wikimap/mapspro/services/mrc/libs/keypoints_matcher/include/superglue_matcher.h>
#include <maps/wikimap/mapspro/services/mrc/libs/keypoints_matcher/include/matcher.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <maps/libs/csv/include/output_stream.h>
#include <maps/libs/introspection/include/hashing.h>
#include <maps/libs/introspection/include/tuple_for_each.h>
#include <maps/libs/geolib/include/line.h>

#include <mapreduce/yt/interface/client.h>

#include <opencv2/opencv.hpp>

#include <optional>
#include <sstream>

namespace maps::mrc::eye::pov {

int64_t getRowsCount(
    const NYT::IClientPtr ytClient,
    const std::string& path);

bool belongsToSamePassage(const db::Feature& feature1, const db::Feature& feature2);

template<typename T>
std::string toTsv(T&& tuple)
{
    std::ostringstream os;
    csv::OutputStream csvWriter(os, '\t');

    introspection::genericForEach(
        std::forward<T>(tuple),
        [&](auto v) {
            csvWriter << v;
        }
    );

    return os.str();
}


} // namespace maps::mrc::eye::pov
