#!/bin/bash
set -x
set -e

GPU_POOL="gpu_geforce_1080ti"

if [ -z "$YT_TMP_FOLDER" ]
then
    echo "YT_TMP_FOLDER is not set"
    exit
fi

if [ -z "$EYE_LOCAL_FOLDER" ]
then
    EYE_LOCAL_FOLDER="."
fi

mkdir -p $EYE_LOCAL_FOLDER

FEATURE_TABLE=$YT_TMP_FOLDER"/feature"
PAIR_TABLE=$YT_TMP_FOLDER"/pair_features"
CLUSTER_YT_FILE=$YT_TMP_FOLDER"/cluster.json"
FEATURE_MASK_TABLE=$YT_TMP_FOLDER"/masks"
FEATURE_OBJECTS_YT_JSON=$YT_TMP_FOLDER"/object.json"
DISTANCE=50
HEADING_DIFF=90
MIN_BOX_SIZE=30
PAIR_FILE="$EYE_LOCAL_FOLDER/predict_visibility_pairs.json"
MATCH_TABLE=$YT_TMP_FOLDER"/matches"
OBJECT_VISIBILITY_TABLE=$YT_TMP_FOLDER"/object_visibility"
OBJECT_VISIBILITY_FACTORS_TABLE=$YT_TMP_FOLDER"/object_visibility_factors"
COLUMNS_DESCRIPTION_TABLE=$YT_TMP_FOLDER"/columns_description"

DESCRIPTOR_TYPE="superpoints_tf"

CLUSTER_VISIBILITY_MODEL_PATH=$YT_TMP_FOLDER/cluster_visibility_model

# Mask
# ../mask/mask \
#     --feature-table $FEATURE_TABLE \
#     --feature-mask-table $FEATURE_MASK_TABLE \
#     --gpu $GPU_POOL

# # Detector
# ../detector/detector \
#     --feature-mask-table $FEATURE_MASK_TABLE \
#     --features-objects-yt-json $FEATURE_OBJECTS_YT_JSON \
#     --gpu $GPU_POOL

# # Filter matches
# ../filter_match_candidates/filter_match_candidates \
#     --feature-table $FEATURE_TABLE \
#     --object-file $FEATURE_OBJECTS_YT_JSON \
#     --distance $DISTANCE \
#     --heading-diff $HEADING_DIFF \
#     --min-box-size $MIN_BOX_SIZE \
#     --pair-file $PAIR_FILE \
#     --ignore-detections

# # Match
./calc_visibility_factors/calc_visibility_factors \
    --feature-table $FEATURE_TABLE \
    --pair-table $PAIR_TABLE \
    --object-file $FEATURE_OBJECTS_YT_JSON \
    --cluster-file $CLUSTER_YT_FILE \
    --output-factors-table $OBJECT_VISIBILITY_FACTORS_TABLE \
    --output-columns-description-table $COLUMNS_DESCRIPTION_TABLE

