#!/bin/bash
set -x
set -e

if [ -z "$EYE_TMP_FOLDER" ]
then
    echo "EYE_TMP_FOLDER is not set"
    exit
fi

if [ -z "$EYE_DATASET_FOLDER" ]
then
    echo "EYE_DATASET_FOLDER is not set"
    exit
fi

if [ -z "$EYE_LOCAL_FOLDER" ]
then
    EYE_LOCAL_FOLDER="."
fi

GPU_POOL="gpu_geforce_1080ti"
FEATURE_TABLE=$EYE_DATASET_FOLDER"/feature"
FEATURE_MASK_TABLE=$EYE_TMP_FOLDER"/mask"
# Use this line if you want to skip detection
# and use objects from dataset
# FEATURE_OBJECTS_YT_JSON=$EYE_DATASET_FOLDER"/object.json"
FEATURE_OBJECTS_YT_JSON=$EYE_TMP_FOLDER"/object.json"
DISTANCE=50
HEADING_DIFF=90
MIN_BOX_SIZE=30
PAIR_FILE=$EYE_LOCAL_FOLDER"/pair.json"
MATCH_TABLE=$EYE_TMP_FOLDER"/match"
DESCRIPTOR_TYPE="superpoints_tf"
MATCH_TYPE="superglue_tf"
MATCH=$EYE_LOCAL_FOLDER"/match.json"
CLUSTER=$EYE_LOCAL_FOLDER"/cluster.json"
CLUSTER_TYPE="greedy"
MIN_MATCH_CONFIDENCE=0.001

# Mask
./mask/mask \
    --feature-table $FEATURE_TABLE \
    --feature-mask-table $FEATURE_MASK_TABLE \
    --gpu $GPU_POOL

# Detector
./detector/detector \
    --feature-mask-table $FEATURE_MASK_TABLE \
    --features-objects-yt-json $FEATURE_OBJECTS_YT_JSON \
    --gpu $GPU_POOL

# Filter matches
./filter_match_candidates/filter_match_candidates \
    --feature-table $FEATURE_TABLE \
    --object-file $FEATURE_OBJECTS_YT_JSON \
    --distance $DISTANCE \
    --heading-diff $HEADING_DIFF \
    --min-box-size $MIN_BOX_SIZE \
    --pair-file $PAIR_FILE

# Match
./match/match \
    --pair-file $PAIR_FILE \
    --mask-table $FEATURE_MASK_TABLE \
    --object-file $FEATURE_OBJECTS_YT_JSON \
    --match-table $MATCH_TABLE \
    --gpu $GPU_POOL \
    --descriptor-type $DESCRIPTOR_TYPE \
    --match-type $MATCH_TYPE

# Export match
./export/export \
    --match-table $MATCH_TABLE \
    --out-file $MATCH

# Cluster
./cluster/cluster \
    --match-file $MATCH \
    --cluster-file $CLUSTER \
    --type $CLUSTER_TYPE \
    --min-box-size $MIN_BOX_SIZE \
    --min-confidence $MIN_MATCH_CONFIDENCE \
    --object-file $FEATURE_OBJECTS_YT_JSON
