#!/bin/bash -e

###############################################################################
# Nvidia 418.67-1 + CUDA 10.0.130-1
###############################################################################

export DEBIAN_FRONTEND=noninteractive

OS=ubuntu1804

nvidia_version=418.67-0
cuda_version=10.0.130-1

nvidia_version_major=${nvidia_version%.*} # a.b -> a
cuda_version_major_minor=${cuda_version%.*} #a.b.c -> a.b
cuda_version_code=${cuda_version_major_minor//./-} #a.b -> a-b

wget -qO - https://developer.download.nvidia.com/compute/cuda/repos/ubuntu1804/x86_64/7fa2af80.pub | sudo apt-key add -

echo "deb http://developer.download.nvidia.com/compute/cuda/repos/$OS/x86_64 /" > /etc/apt/sources.list.d/nvidia.list
echo "deb http://developer.download.nvidia.com/compute/machine-learning/repos/$OS/x86_64 /" >> /etc/apt/sources.list.d/nvidia.list

apt --allow-insecure-repositories --allow-unauthenticated update

apt install --yes --no-install-recommends --upgrade \
    "libnvidia-compute-${nvidia_version_major}=${nvidia_version}ubuntu1" \
    "cuda-cublas-${cuda_version_code}=${cuda_version}" \
    "cuda-cufft-${cuda_version_code}=${cuda_version}" \
    "cuda-cusolver-${cuda_version_code}=${cuda_version}" \
    "cuda-curand-${cuda_version_code}=${cuda_version}" \
    "cuda-cudart-${cuda_version_code}=${cuda_version}" \
    "cuda-cusparse-${cuda_version_code}=${cuda_version}" \
    "libcudnn7=7.6.5.32-1+cuda${cuda_version_major_minor}" \
    "libnccl2=2.6.4-1+cuda${cuda_version_major_minor}" \

###############################################################################
# Configure dynamic linker
###############################################################################

cuda_conf=/etc/ld.so.conf.d/cuda-${cuda_version_major_minor}.conf
sudo echo /usr/local/cuda-${cuda_version_major_minor}/lib64 > "${cuda_conf}"
echo /usr/lib/x86_64-linux-gnu >> "${cuda_conf}"

nvidia_conf=/etc/ld.so.conf.d/nvidia-${nvidia_version_major}.conf
echo /usr/lib/nvidia-${nvidia_version_major} > "${nvidia_conf}"

ldconfig

###############################################################################
# Install Python3 + packages
###############################################################################

apt install --yes --no-install-recommends --upgrade \
    python3 \
    python3-pip \
    python3-setuptools \
    python3-numpy \
    libgl1-mesa-glx \
    ffmpeg \

pip3 install --no-cache-dir -U pip
pip3 install -i https://pypi.yandex-team.ru/simple/ yandex-yt
pip3 install -i https://pypi.yandex-team.ru/simple/ yandex-yt-yson-bindings

pip3 install --no-cache-dir -U \
    tensorflow-gpu==1.14 \
    opencv-python \

pip3 install --no-cache-dir -U \
    -f https://download.pytorch.org/whl/torch_stable.html \
    torch==1.4.0+cu100 \
    torchvision==0.5.0+cu100 \

############################################################################
# Clean
############################################################################

apt autoremove --yes
apt clean
apt autoclean

rm -rf /var/cache
rm -rf /var/log

rm -rf /var/lib/apt/lists/*

rm -rf /tmp/*
rm -rf /var/tmp/*

############################################################################
# Python3 check
############################################################################
python3 --version

python3 -c 'import tensorflow; print("tensorflow", tensorflow.__version__)'
python3 -c 'import torch; print("torch",  torch.__version__)'
python3 -c 'import cv2; print("opencv", cv2.__version__)'
