import os

import vh3

from . import ops

CUDA_BUILD_DEFINITIONS_FLAGS = "-DTENSORFLOW_WITH_CUDA=1 -DCUDA_VERSION=10.1 -DNO_DEBUGINFO"
SIGNS_MAP_TTL = 1440
SIGNS_MAP_MAX_RAM = 2048
CLUSTER_QUALITY_MAX_RAM = 512


class ServiceContext(vh3.DefaultContext):
    yav_token: vh3.Secret


def yt_download_json_file(path: str):
    mr_file = vh3.lib.services.yt.get_mr_file(path)
    text_file = vh3.lib.services.yt.download_file(mr_file, vh3.Text)
    return ops.convert_any_to_json(file=text_file)


@vh3.decorator.graph()
def eval_qa() -> None:
    sign_cluster_revision = 9555128
    qa_tools_revision = 7669030

    mrc_secret_version = "sec-01fjesdh3jykc9s87detcnw9mr"
    dataset_yt_dir = "//home/maps/core/mrc/signs_map"
    universal_datasets = ["dataset_0", "dataset_1"]

    partially_marked_datasets = ["dataset_2"]

    valid_classes_list: ops.SvnExportSingleFileOutput = ops.svn_export_single_file_deterministic(
        arcadia_path="valid_prod_classes.txt",
        path_prefix="trunk/arcadia/maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/clusters_quality_test",
        revision=qa_tools_revision,
    )

    ya_file = ops.svn_export_single_file_deterministic(arcadia_path="arcadia/ya", path_prefix="", revision=qa_tools_revision)

    migrations = ops.svn_checkout_deterministic(
        arcadia_path="arcadia/maps/wikimap/mapspro/services/mrc/migrations/migrations",
        path_prefix="",
        revision=sign_cluster_revision,
    )

    config = ops.svn_export_single_file_deterministic(
        arcadia_path="t-config.production.xml",
        path_prefix="trunk/arcadia/maps/wikimap/mapspro/services/mrc/libs/config/cfg",
    )

    sign_cluster_bin = ops.build_arcadia_project(
        arcadia_revision=sign_cluster_revision,
        targets="maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/sign_cluster",
        arts="maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/sign_cluster/sign-cluster",
        definition_flags=CUDA_BUILD_DEFINITIONS_FLAGS,
        arcadia_patch=None,
    )

    clusters_quality_test_bin = ops.build_arcadia_project(
        arcadia_revision=qa_tools_revision,
        targets="maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/clusters_quality_test",
        arts="maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/clusters_quality_test/clusters_quality_test",
        definition_flags="-DNO_DEBUGINFO ",
    )

    report_list = []

    for dataset in universal_datasets:
        report_header = "Dataset {0}\n".format(dataset)
        report_list.append(vh3.echo(report_header))
        dataset_path = os.path.join(dataset_yt_dir, dataset)
        object_json = yt_download_json_file(path=os.path.join(dataset_path, "object.json"))
        cluster_json = yt_download_json_file(path=os.path.join(dataset_path, "cluster.json"))
        features_table_path = os.path.join(dataset_path, "feature")

        signs_map = ops.run_playground_signs_map(
            ya=ya_file.executable,
            migrations=migrations.archive,
            mrc_config=config.text,
            playground=sign_cluster_bin.arcadia_project,
            features=features_table_path,
            secret_version=mrc_secret_version,
            ttl=SIGNS_MAP_TTL,
            max_ram=SIGNS_MAP_MAX_RAM,
        )

        clusters_quality_test_signs_map_result = ops.clusters_quality_test_signs_map(
            gt_objects=object_json,
            gt_clusters=cluster_json,
            test_objects=signs_map.export_detections,
            test_clusters=signs_map.export_clusters,
            quality=clusters_quality_test_bin.arcadia_project,
            max_ram=CLUSTER_QUALITY_MAX_RAM,
        )

        clusters_quality_valid_classes = ops.clusters_quality_test_signs_map(
            valid_classes=valid_classes_list.text,
            gt_objects=object_json,
            gt_clusters=cluster_json,
            test_objects=signs_map.export_detections,
            test_clusters=signs_map.export_clusters,
            quality=clusters_quality_test_bin.arcadia_project,
            max_ram=CLUSTER_QUALITY_MAX_RAM,
        )

        signs_map_on_gt_detections = ops.run_playground_signs_map(
            gt_objects=object_json,
            ya=ya_file.executable,
            migrations=migrations.archive,
            mrc_config=config.text,
            playground=sign_cluster_bin.arcadia_project,
            features=features_table_path,
            secret_version=mrc_secret_version,
            ttl=SIGNS_MAP_TTL,
            max_ram=SIGNS_MAP_MAX_RAM,
        )

        clusters_quality_gt_detections = ops.clusters_quality_test_signs_map(
            gt_objects=object_json,
            gt_clusters=cluster_json,
            test_objects=signs_map_on_gt_detections.export_detections,
            test_clusters=signs_map_on_gt_detections.export_clusters,
            quality=clusters_quality_test_bin.arcadia_project,
            max_ram=CLUSTER_QUALITY_MAX_RAM,
        )

        clusters_quality_gt_detections_valid_classes = ops.clusters_quality_test_signs_map(
            valid_classes=valid_classes_list.text,
            gt_objects=object_json,
            gt_clusters=cluster_json,
            test_objects=signs_map_on_gt_detections.export_detections,
            test_clusters=signs_map_on_gt_detections.export_clusters,
            quality=clusters_quality_test_bin.arcadia_project,
            max_ram=CLUSTER_QUALITY_MAX_RAM,
        )

        report = ops.quality_report_signs_map(
            quality=clusters_quality_test_signs_map_result,
            valid_quality=clusters_quality_valid_classes,
            gt_quality=clusters_quality_gt_detections,
            gt_valid_quality=clusters_quality_gt_detections_valid_classes,
        )
        report_list.append(report)

    for dataset in partially_marked_datasets:
        report_header = "Dataset {0}\n".format(dataset)
        report_list.append(vh3.echo(report_header))
        dataset_path = os.path.join(dataset_yt_dir, dataset)
        object_json = yt_download_json_file(path=os.path.join(dataset_path, "object.json"))
        cluster_json = yt_download_json_file(path=os.path.join(dataset_path, "cluster.json"))
        features_table_path = os.path.join(dataset_path, "feature")

        signs_map_on_gt_detections = ops.run_playground_signs_map(
            gt_objects=object_json,
            ya=ya_file.executable,
            migrations=migrations.archive,
            mrc_config=config.text,
            playground=sign_cluster_bin.arcadia_project,
            features=features_table_path,
            secret_version=mrc_secret_version,
            ttl=SIGNS_MAP_TTL,
            max_ram=SIGNS_MAP_MAX_RAM,
        )

        clusters_quality_gt_detections: vh3.Text = ops.clusters_quality_test_signs_map(
            gt_objects=object_json,
            gt_clusters=cluster_json,
            test_objects=signs_map_on_gt_detections.export_detections,
            test_clusters=signs_map_on_gt_detections.export_clusters,
            quality=clusters_quality_test_bin.arcadia_project,
            max_ram=CLUSTER_QUALITY_MAX_RAM,
        )

        report = ops.quality_report_signs_map(
            gt_quality=clusters_quality_gt_detections,
        )

        report_list.append(report)

    ops.concat_text(inputs=report_list)
